/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.ipp;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.JTextPane;
import javax.swing.plaf.basic.BasicTextPaneUI;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.ipp.IppPrintable;
import ru.softlogic.hardware.device.print.ipp.IppPrinterOptions;
import ru.softlogic.system.util.ThreadUtil;

public class DefaultIppPrintable
implements IppPrintable {
    private String text;
    private IppPrinterOptions options;
    private int printWidth;
    private final Logger log = Logger.getLogger((String)"print");

    @Override
    public void init(IppPrinterOptions options, int printWidth, String text) {
        this.text = text;
        this.options = options;
        this.printWidth = printWidth;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        String fontFamily = null;
        int fontSize = 9;
        if (this.options != null) {
            fontFamily = this.options.getFontFamily();
            fontSize = this.options.getFontSize();
            if (fontSize < 4 || fontSize > 20) {
                fontSize = 9;
            }
        }
        this.text = "<table style=\"" + (fontFamily != null && !fontFamily.isEmpty() ? "font-family:" + fontFamily + ";" : "font-family:Arial;") + "font-size:" + fontSize + "pt;\"><tr><td width=\"" + this.printWidth + "mm\" >" + this.text + "</td></tr></table>";
        if (this.options != null && this.options.getFontSize() > 0) {
            this.text = this.text + "<div style=\"padding-top:" + this.options.getScroll() + "mm\">.</div>";
        }
        this.log.info((Object)("\u0422\u0435\u043a\u0441\u0442 \u0434\u043b\u044f \u043f\u0435\u0447\u0430\u0442\u0438: " + this.text));
        if (pageIndex == 0) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g2d.setColor(Color.black);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2d.setFont(new Font(fontFamily, 0, fontSize));
            JTextPane pane = new JTextPane();
            pane.setBackground(Color.WHITE);
            pane.setUI(new BasicTextPaneUI());
            pane.setContentType("text/html");
            pane.setBorder(null);
            pane.setBounds(0, 0, 0, 0);
            pane.setText(this.text);
            pane.setDoubleBuffered(false);
            pane.setSize(1000, 2000);
            pane.print(g2d);
            ThreadUtil.sleep((long)500L);
            pane.print(g2d);
            return 0;
        }
        return 1;
    }

    public String toString() {
        return "DefaultIppPrintable{}";
    }
}

