/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.modem.resources;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ModemHelper {
    public static String getUssdRequest(int operator, String name) {
        ResourceBundle ussdBundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.modem.resources.codes");
        if (name != null) {
            try {
                return ussdBundle.getString("operator." + operator + "." + name.toLowerCase() + ".ussd");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            return ussdBundle.getString("operator." + operator + ".ussd");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getUssdPhoneRequest(int operator, String name) {
        ResourceBundle ussdBundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.modem.resources.codes");
        if (name != null) {
            try {
                return ussdBundle.getString("operator." + operator + "." + name.toLowerCase() + ".phone.ussd");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            return ussdBundle.getString("operator." + operator + ".phone.ussd");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getPowerOffRequest(String vendor) {
        if (vendor == null) {
            return null;
        }
        ResourceBundle ussdBundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.modem.resources.codes");
        try {
            return ussdBundle.getString("vendor." + vendor.toLowerCase().trim().replace(" ", "_") + ".watchdog");
        }
        catch (Exception ex) {
            try {
                return ussdBundle.getString("vendor.unknown.watchdog");
            }
            catch (Exception ex1) {
                return null;
            }
        }
    }

    public static String getIccidRequest(String vendor) {
        if (vendor == null) {
            return null;
        }
        ResourceBundle ussdBundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.modem.resources.codes");
        try {
            return ussdBundle.getString("vendor." + vendor.toLowerCase().trim().replace(" ", "_") + ".iccid");
        }
        catch (Exception ex) {
            try {
                return ussdBundle.getString("vendor.unknown.iccid");
            }
            catch (Exception ex1) {
                return null;
            }
        }
    }

    public static String getIccidRegexResponse(String vendor) {
        if (vendor == null) {
            return null;
        }
        ResourceBundle ussdBundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.modem.resources.codes");
        try {
            return ussdBundle.getString("vendor." + vendor.toLowerCase().trim().replace(" ", "_") + ".iccid.regex");
        }
        catch (Exception ex) {
            try {
                return ussdBundle.getString("vendor.unknown.iccid.regex");
            }
            catch (Exception ex1) {
                return null;
            }
        }
    }

    public static boolean isPDURequire(String vendor) {
        if (vendor == null) {
            return false;
        }
        ResourceBundle ussdBundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.modem.resources.codes");
        try {
            return Boolean.parseBoolean(ussdBundle.getString("vendor." + vendor.toLowerCase() + ".ussd.pdu-require"));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isUssdRequeryForSearch(String vendor) {
        if (vendor == null) {
            return false;
        }
        ResourceBundle ussdBundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.modem.resources.codes");
        try {
            return Boolean.parseBoolean(ussdBundle.getString("vendor." + vendor.toLowerCase() + ".search.ussd-require"));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isUssdCheckNeeded(String vendor) {
        if (vendor == null) {
            return false;
        }
        ResourceBundle ussdBundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.modem.resources.codes");
        try {
            return Boolean.parseBoolean(ussdBundle.getString("vendor." + vendor.toLowerCase() + ".search.ussd"));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isUssdModifyNeeded(String vendor) {
        if (vendor == null) {
            return false;
        }
        ResourceBundle ussdBundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.modem.resources.codes");
        try {
            return Boolean.parseBoolean(ussdBundle.getString("vendor." + vendor.toLowerCase() + ".ussd.modify-needed"));
        }
        catch (Exception ex) {
            return false;
        }
    }
}

