/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.modem.drivers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.modem.MemoryStore;
import ru.softlogic.hardware.device.modem.MemoryType;
import ru.softlogic.hardware.device.modem.MessageFormatException;
import ru.softlogic.hardware.device.modem.ModemApi;
import ru.softlogic.hardware.device.modem.ModemConnector;
import ru.softlogic.hardware.device.modem.ModemException;
import ru.softlogic.hardware.device.modem.PDUUtils;
import ru.softlogic.hardware.device.modem.Registration;
import ru.softlogic.hardware.device.modem.Sms;
import ru.softlogic.hardware.device.modem.SmsBox;
import ru.softlogic.hardware.device.modem.SmsMode;
import ru.softlogic.hardware.device.modem.UCS2Encoder;
import ru.softlogic.hardware.device.modem.batch.ModemIniter;
import ru.softlogic.hardware.device.modem.resources.ModemHelper;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class GenericModemApi
implements ModemApi,
SerialDeviceApi {
    private int timeout = 1500;
    public static final String STORAGE_SIM = "SM";
    public static final String STORAGE_ME = "ME";
    public static final String STORAGE_BROADCAST = "BM";
    public static final String STORAGE_ANY_ME = "MT";
    public static final String STORAGE_TA = "TA";
    public static final String STORAGE_REPORTS = "SR";
    public static final int SMS_MODE_PDU = 1;
    private SerialPort port;
    private Logger log;
    private ModemConnector connector;

    public GenericModemApi(SerialPort connection) {
        if (connection == null) {
            throw new IllegalArgumentException("");
        }
        this.port = connection;
        this.connector = new ModemConnector(connection);
        if (connection.isOpen()) {
            connection.close();
        }
        this.log = Logger.getLogger((String)"modem");
        this.log.setAdditivity(false);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public String getVendor() throws ModemException {
        this.log.debug((Object)"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f");
        List<String> res = this.connector.send("AT+CGMI", this.timeout);
        this.log.info((Object)("Vendor: " + res));
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.debug((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return res.get(0).trim().replace("\r", "").replace("\n", "");
        }
        this.log.debug((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043e\u0442\u0432\u0435\u0442\u0430: " + res);
    }

    @Override
    public String getModel() throws ModemException {
        this.log.debug((Object)"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043c\u043e\u0434\u0435\u043b\u0438");
        List<String> res = this.connector.send("AT+CGMM", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.debug((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return res.get(0).trim().replace("\r", "").replace("\n", "");
        }
        this.log.debug((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043e\u0442\u0432\u0435\u0442\u0430");
    }

    @Override
    public String getFirmware() throws ModemException {
        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0438 \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u0438");
        List<String> res = this.connector.send("AT+CGMR", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return res.get(0).trim().replace("\r", "").replace("\n", "");
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043e\u0442\u0432\u0435\u0442\u0430");
    }

    @Override
    public long getImei() throws ModemException {
        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 IMEI");
        List<String> res = this.connector.send("AT+CGSN", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return Long.parseLong(res.get(0).trim());
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043e\u0442\u0432\u0435\u0442\u0430");
    }

    @Override
    public long getImsi() throws ModemException {
        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 IMSI");
        List<String> res = this.connector.send("AT+CIMI", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return Long.parseLong(res.get(0).trim());
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043e\u0442\u0432\u0435\u0442\u0430");
    }

    @Override
    public boolean isPowerManagement() throws ModemException {
        this.log.info((Object)"\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043f\u0438\u0442\u0430\u043d\u0438\u044f");
        List<String> res = this.connector.send("AT+CFUN=?", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        return false;
    }

    @Override
    public boolean rebootGprsModule(String cmd) throws ModemException {
        this.log.info((Object)("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0438\u0442\u0430\u043d\u0438\u0435\u043c GPRS \u043c\u043e\u0434\u0443\u043b\u044f. \u041f\u043e\u0441\u044b\u043b\u0430\u044e " + cmd));
        List<String> res = this.connector.send(cmd, 1000);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        return false;
    }

    @Override
    public boolean enableErrorDesc(boolean enable) throws ModemException {
        this.log.info((Object)"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u043e\u0439 \u043e\u0448\u0438\u0431\u043e\u043a");
        List<String> res = this.connector.send("AT+CMEE=" + (enable ? (char)'1' : '0'), this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        return false;
    }

    @Override
    public int getActivity() throws ModemException {
        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 ");
        List<String> res = this.connector.send("AT+CPAS", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            String[] tmp;
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            String data = res.get(0);
            if (data.matches("\\+CPAS: [\\d]{1,2}") && (tmp = data.split(" ")).length == 2) {
                try {
                    return Integer.parseInt(tmp[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043e\u0442\u0432\u0435\u0442\u0430");
    }

    @Override
    public void reset() throws ModemException {
        this.log.info((Object)"\u0421\u0431\u0440\u043e\u0441 \u043c\u043e\u0434\u0435\u043c\u0430");
        List<String> res = this.connector.send("ATZ", this.timeout);
        if (res.size() <= 0 || !res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
            throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
        this.connector.send("AT+CMEE=2", this.timeout);
    }

    @Override
    public void setTextMode() throws ModemException {
        this.log.info((Object)"\u0412 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c");
        this.connector.send("+++", this.timeout, false);
    }

    @Override
    public void configure() throws ModemException {
        this.log.info((Object)"Configure modem");
        this.connector.send("AT S7=45 S0=0 L1 V1 X4 &c1 E1 Q0", this.timeout, false);
    }

    @Override
    public int getSignalLevel() throws ModemException {
        this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0443\u0440\u043e\u0432\u043d\u044f \u0441\u0438\u0433\u043d\u0430\u043b\u0430");
        List<String> res = this.connector.send("AT+CSQ", this.timeout);
        this.log.debug(res);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            String[] tmp;
            String data = res.get(0).toUpperCase();
            this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + data));
            if (data.matches("\\+CSQ: [\\d]{1,2},[\\d]{1,2}") && (tmp = data.split(" ")).length == 2 && (tmp = tmp[1].split(",")).length == 2) {
                try {
                    return Integer.parseInt(tmp[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
        }
        this.log.debug((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430");
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
    }

    @Override
    public boolean dial(String number) throws ModemException {
        this.log.info((Object)("\u0417\u0432\u043e\u043d\u043e\u043a \u043d\u0430 \u043d\u043e\u043c\u0435\u0440 " + number));
        List<String> res = this.connector.send("ATD" + number + ";", 20000);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        return false;
    }

    @Override
    public boolean cancel() throws ModemException {
        this.log.info((Object)"\u041a\u043b\u0430\u0434\u0435\u043c \u0442\u0440\u0443\u0431\u043a\u0443");
        List<String> res = this.connector.send("ATH", this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        return false;
    }

    @Override
    public String getOperatorName() throws ModemException {
        this.log.debug((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        List<String> res = this.connector.send("AT+COPS=3,0", this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            res = this.connector.send("AT+COPS?", this.timeout);
            if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
                String result = res.get(0);
                Pattern p = Pattern.compile("\\+COPS: [\\d],[\\d],\\\"(.*)\\\"");
                Matcher m2 = p.matcher(result);
                if (m2.find()) {
                    return m2.group(1);
                }
                throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
            }
            this.log.debug((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430");
            throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
        }
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u0432 \u0440\u0435\u0436\u0438\u043c \u043f\u043e\u043a\u0430\u0437\u0430 \u0438\u043c\u0435\u043d\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
    }

    @Override
    public int getOperatorId() throws ModemException {
        this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        List<String> res = this.connector.send("AT+COPS=3,2", this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            res = this.connector.send("AT+COPS?", this.timeout);
            if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
                String result = res.get(0);
                Pattern p = Pattern.compile("\\+COPS: [\\d],[\\d],\"?([\\d]*)\"?");
                Matcher m2 = p.matcher(result);
                if (m2.find()) {
                    return Integer.parseInt(m2.group(1));
                }
                throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
            }
            this.log.debug((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430");
            throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
        }
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u0432 \u0440\u0435\u0436\u0438\u043c \u043f\u043e\u043a\u0430\u0437\u0430 \u0438\u043c\u0435\u043d\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
    }

    @Override
    public String executeUssd(String cmd, boolean pduRequire) throws ModemException {
        return this.executeUssd(cmd, pduRequire, 60000);
    }

    @Override
    public String executeAtd(String cmd, boolean pduRequire) throws ModemException {
        return this.executeAtd(cmd, pduRequire, 60000);
    }

    @Override
    public String executeAtd(String cmd, boolean pduRequire, int timeout) throws ModemException {
        List<String> res;
        this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 atd: " + cmd));
        if (pduRequire) {
            cmd = PDUUtils.encodePDU(cmd);
        }
        if ((res = this.connector.sendUssd(cmd, '\r', timeout)).size() > 1 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + res.get(0)));
            String result = res.get(1);
            result = result.replace("\r", "").replace("\n", "");
            if (!result.matches("\\+CUSD: \\d,\".*\".*")) {
                throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 USSD \u0437\u0430\u043f\u0440\u043e\u0441");
            }
            String message = result.substring(result.indexOf("\"") + 1, result.lastIndexOf("\",") > 0 ? result.indexOf("\",") : result.length());
            try {
                result = pduRequire ? new String(UCS2Encoder.hexToBuffer(PDUUtils.decodePDUtoHex(message)), "UTF-16") : new String(UCS2Encoder.hexToBuffer(message), "UTF-16");
            }
            catch (Exception ex) {
                result = message;
            }
            this.log.debug((Object)("\u041e\u043a\u043e\u043d\u0447\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + result));
            return result;
        }
        this.log.debug((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430");
        return "undefined";
    }

    @Override
    public String executeUssd(String cmd, boolean pduRequire, int timeout) throws ModemException {
        this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 ussd: " + cmd));
        String request = pduRequire ? PDUUtils.encodePDU(cmd) : cmd;
        List<String> res = null;
        try {
            res = this.connector.sendUssd("AT+CUSD=1,\"" + request + "\",15", '\r', timeout);
            if (res.size() < 1 || !res.get(0).equalsIgnoreCase("ok") || res.get(1).equalsIgnoreCase("ERROR")) {
                throw new ModemException();
            }
        }
        catch (ModemException ex) {
            try {
                this.connector.send("AT+CUSD=2", timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            res = this.connector.sendUssd("ATD" + cmd + ";", '\r', timeout);
        }
        if (res.size() > 1 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + res.get(0)));
            String result = res.get(1);
            result = result.replace("\r", "").replace("\n", "");
            if (!result.matches("\\+CUSD: \\d,\".*\".*")) {
                throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 USSD \u0437\u0430\u043f\u0440\u043e\u0441");
            }
            String message = result.substring(result.indexOf("\"") + 1, result.lastIndexOf("\",") > 0 ? result.indexOf("\",") : result.length());
            try {
                if (result.endsWith("72")) {
                    return new String(BU.convertFromHex((String)message), "UTF-16");
                }
                return new String(UCS2Encoder.hexToBuffer(PDUUtils.decodePDUtoHex(message)), "UTF-16");
            }
            catch (Exception ex) {
                result = message;
                this.log.debug((Object)("\u041e\u043a\u043e\u043d\u0447\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + result));
                return result;
            }
        }
        this.log.debug((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430");
        return "undefined";
    }

    public boolean setRegistrationMode(int mode) throws ModemException {
        this.log.info((Object)("\u0420\u0435\u0436\u0438\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 " + mode));
        List<String> res = this.connector.send("AT+CREG=" + mode, this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        return false;
    }

    @Override
    public Registration getRegistration() throws ModemException {
        this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438");
        List<String> res = this.connector.send("AT+CREG?", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            String result = res.get(0);
            this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: " + result));
            if (result.matches("\\+CREG: (0|1|2),(0|1|2|3|4|5)(,.*{1,7})?(,.*{1,7})?")) {
                String[] tmp = result.replaceAll("\"", "").split(",");
                if (tmp.length == 2) {
                    return new Registration(Integer.parseInt(tmp[1]));
                }
                return new Registration(Integer.parseInt(tmp[1]), tmp[2], tmp[3]);
            }
        }
        this.log.debug((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430");
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
    }

    @Override
    public boolean transmitTones(String data) throws ModemException {
        this.log.info((Object)"\u041f\u043e\u0441\u044b\u043b\u0430\u0435\u043c \u0442\u043e\u043d\u043e\u0432\u043e\u044e \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0443");
        List<String> res = this.connector.send("AT+VTS=" + data, this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
    }

    @Override
    public boolean setToneDuration(int nsec) throws ModemException {
        this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043d\u0430\u0436\u0430\u0442\u0438\u044f \u043a\u043b\u0430\u0432\u0438\u0448");
        List<String> res = this.connector.send("AT+VTD=" + String.valueOf(nsec), this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
    }

    @Override
    public boolean smsMode(SmsMode mode) throws ModemException {
        if (mode == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 SMS");
        }
        this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0440\u0435\u0436\u0438\u043c SMS: " + (Object)((Object)mode)));
        List<String> res = this.connector.send("AT+CMGF=" + mode.getCode(), this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
    }

    @Override
    public MemoryStore[] smsStores() throws ModemException {
        String result;
        this.log.info((Object)"\u0427\u0438\u0442\u0430\u0435\u043c \u0438\u043c\u0435\u043d\u0430 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u044c sms");
        List<String> res = this.connector.send("AT+CPMS=?", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok") && (result = res.get(0).trim()).startsWith("+CPMS: ")) {
            String[] mem = (result = result.substring(7)).split("\\),\\(");
            if (mem.length == 3) {
                LinkedList<MemoryStore> list = new LinkedList<MemoryStore>();
                Pattern p = Pattern.compile("([A-Z]+,?)");
                for (int i = 0; i < 3; ++i) {
                    Matcher m2 = p.matcher(mem[i]);
                    while (m2.find()) {
                        if (i == 0) {
                            list.add(new MemoryStore(m2.group(0), MemoryType.RD));
                            continue;
                        }
                        if (i == 1) {
                            list.add(new MemoryStore(m2.group(0), MemoryType.WS));
                            continue;
                        }
                        list.add(new MemoryStore(m2.group(0), MemoryType.RS));
                    }
                }
                return list.toArray(new MemoryStore[list.size()]);
            }
            this.log.error((Object)"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0433\u0440\u0443\u043f\u043f \u043d\u0435 \u0440\u0430\u0432\u043d\u043e 3. \u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043e\u0442\u0432\u0435\u0442\u0430");
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
    }

    @Override
    public Map<String, SmsBox> smsCount() throws ModemException {
        String result;
        this.log.info((Object)"\u0427\u0438\u0442\u0430\u0435\u043c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e sms");
        List<String> res = this.connector.send("AT+CPMS?", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok") && (result = res.get(0).trim()).startsWith("+CPMS: ")) {
            result = result.substring(7);
            Pattern p = Pattern.compile("(\"[A-Z]+\",\\d+,\\d+,?)");
            Pattern p2 = Pattern.compile("\"([A-Z]+)\",(\\d+),(\\d+),?");
            Matcher m2 = p.matcher(result);
            HashMap<String, SmsBox> map = new HashMap<String, SmsBox>();
            while (m2.find()) {
                Matcher m22 = p2.matcher(m2.group(0));
                while (m22.find()) {
                    try {
                        map.put(m22.group(1), new SmsBox(Integer.parseInt(m22.group(2)), Integer.parseInt(m22.group(3))));
                    }
                    catch (NumberFormatException ex) {
                        this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0430\u0442\u0430 \u0447\u0438\u0441\u043b\u0430, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u044e", (Throwable)ex);
                    }
                }
            }
            return map;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
    }

    @Override
    public boolean smsMem(String name) throws ModemException {
        this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0442\u0438\u043f \u043f\u0430\u043c\u044f\u0442\u0438 \u0434\u043b\u044f sms: " + name));
        List<String> res = this.connector.send("AT+CPMS=\"" + name + "\"", this.timeout);
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        throw new ModemException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442");
    }

    @Override
    public boolean smsClear() throws ModemException {
        this.log.info((Object)"\u0423\u0434\u0430\u043b\u044f\u0435\u043c \u0432\u0441\u0435 SMS \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
        List<String> res = this.connector.send("AT+CNUM", this.timeout);
        if (res.size() > 0 && res.get(0).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK");
            return true;
        }
        this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
        return false;
    }

    @Override
    public boolean smsSend(String phone, String message) throws MessageFormatException, ModemException {
        this.log.info((Object)"\u041e\u0442\u0441\u044b\u043b\u0430\u0435\u043c \u0441\u043c\u0441");
        if (!message.matches("[\\dA-Za-z\\.,;]{1,170}")) {
            throw new MessageFormatException("\u0424\u043e\u0440\u043c\u0430\u0442 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043d\u0435\u0432\u0435\u0440\u0435\u043d");
        }
        List<String> res = this.connector.sendSms("AT+CMGS=\"" + phone + "\"", message, 10000);
        return true;
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.connector.getAvailableParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        for (SerialParams params : this.connector.getSerialParams().get(preferred)) {
            try {
                this.log.info((Object)("Search standart AT-modem on port: " + this.port.getName()));
                this.port.putParams(params);
                this.open();
                this.setTimeout(1000);
                new ModemIniter(this).process();
                this.log.info((Object)"Try to get model");
                String model = this.getModel();
                this.log.info((Object)("Model: " + model));
                this.log.info((Object)"Try to get vendor");
                String vendor = this.getVendor();
                if (ModemHelper.isUssdRequeryForSearch(vendor)) {
                    this.log.info((Object)("Vendor '" + vendor + "' is require additional ussd check"));
                    int operator = this.getOperatorId();
                    String name = this.getOperatorName();
                    String ussd = ModemHelper.getUssdRequest(operator, name);
                    if (ussd != null) {
                        this.log.info((Object)"Check by executing ussd request");
                        this.executeUssd(ussd, ModemHelper.isPDURequire(vendor), 15000);
                        this.log.info((Object)"Modem port confirmed");
                    }
                }
                this.log.info((Object)"Modem found");
                DeviceType deviceType = null;
                return deviceType;
            }
            catch (Exception ex) {
                this.log.info((Object)("Modem is not found. Cause: " + ex.getMessage()));
            }
            finally {
                this.port.close();
            }
        }
        throw new NoSuchDeviceException("Device on port " + this.port.getName() + " not is " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.GenericModem;
    }

    @Override
    public void open() throws IOException {
        this.connector.open();
    }

    @Override
    public void close() {
        this.connector.close();
    }

    public List<Sms> readAllSms() throws ModemException {
        this.connector.send("AT+CMGF=1", 5000);
        List<String> send = this.connector.send("AT+CMGL=\"ALL\"", 5000);
        ArrayList<Sms> result = new ArrayList<Sms>(send.size());
        for (int i = 0; i < send.size() - 1; i += 2) {
            Sms sms = new Sms(send.get(i), send.get(i + 1));
            result.add(sms);
        }
        return result;
    }

    public Sms readSms(int index) throws ModemException {
        List<String> send = this.connector.send("AT+CMGR=" + index, 5000);
        if (send.size() == 3 && send.get(2).equalsIgnoreCase("OK")) {
            return new Sms(send.get(0), send.get(1));
        }
        return null;
    }

    public String getLastSms() throws ModemException {
        List<Sms> smsList = this.readAllSms();
        if (smsList != null && !smsList.isEmpty()) {
            return smsList.get(smsList.size() - 1).getText();
        }
        return null;
    }

    public String executeUssd(String request, String ussdRegex, String smsRegex, boolean isPdu, int smsTimeout) throws ModemException {
        this.selectSmsStorage(STORAGE_SIM);
        boolean smsClear = this.smsClear();
        String data = this.executeUssd(request, isPdu, 10000);
        if (data != null) {
            data = data.replace("\n", "");
        }
        this.log.info((Object)("data: " + data));
        if ((smsRegex == null || smsRegex.isEmpty()) && (ussdRegex == null || ussdRegex.isEmpty())) {
            ussdRegex = "^(.*)$";
        }
        if (ussdRegex != null && !ussdRegex.isEmpty() && data != null && data.matches(ussdRegex)) {
            return data.replaceAll(ussdRegex, "$1").trim();
        }
        if (smsClear && smsRegex != null && !smsRegex.isEmpty()) {
            String lastSmsText = null;
            for (int attempts = 0; attempts < 20 && lastSmsText == null; ++attempts) {
                try {
                    Thread.sleep(smsTimeout);
                    lastSmsText = this.getLastSms();
                    this.log.debug((Object)("attempts: " + (attempts + 1)));
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            if (lastSmsText != null && (lastSmsText = lastSmsText.trim()).matches(smsRegex)) {
                return lastSmsText.replaceAll(smsRegex, "$1");
            }
            return "USSD: " + data + "| SMS: " + (lastSmsText == null ? "-" : lastSmsText);
        }
        return "\u041e\u0442\u0432\u0435\u0442 \u043d\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d";
    }

    public boolean selectSmsStorage(String storage) throws ModemException {
        List<String> send = this.connector.send("AT+CPMS=" + storage, 5000);
        return send.size() > 0 && send.get(0).equalsIgnoreCase("OK");
    }

    @Override
    public String getIccid() throws ModemException {
        String response;
        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 ICIID");
        String vendor = this.getVendor();
        String result = "";
        List<String> res = this.connector.send(ModemHelper.getIccidRequest(vendor), this.timeout);
        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442:" + res));
        if (res.size() > 1 && res.get(1).equalsIgnoreCase("ok")) {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a OK. \u0412\u044b\u0447\u043b\u0435\u043d\u044f\u0435\u043c ICCID \u0438\u0437 \u043e\u0442\u0432\u0435\u0442\u0430");
            response = res.get(0).trim();
            Pattern pattern = Pattern.compile(ModemHelper.getIccidRegexResponse(vendor));
            Matcher matcher = pattern.matcher(response);
            if (matcher.find()) {
                response = matcher.group(1).trim();
            }
        } else {
            this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u043f\u0440\u0435\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a ERROR");
            throw new ModemException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043e\u0442\u0432\u0435\u0442\u0430");
        }
        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 ICCID: " + response));
        result = this.checkIccid(response);
        return result;
    }

    private String checkIccid(String iccid) {
        if (iccid.startsWith("98")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0432\u044b\u0435 \u0446\u0438\u0444\u0440\u044b 98, \u0430 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c 89. \u0420\u0430\u0437\u0432\u043e\u0440\u0430\u0447\u0438\u0432\u0430\u0435\u043c \u043f\u043e\u043f\u0430\u0440\u043d\u043e");
            String[] str = iccid.split("(?<=\\G.{2})");
            StringBuilder result = new StringBuilder();
            for (String s : str) {
                result.append(new StringBuffer(s).reverse());
            }
            this.log.info((Object)("\u0418\u0442\u043e\u0433\u043e\u0432\u043e\u0435 ICCID: " + result));
            return result.toString();
        }
        return iccid;
    }
}

