/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.modem;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.modem.ModemException;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.system.util.ArrayUtils;
import ru.softlogic.system.util.ThreadUtil;

public class ModemConnector {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final byte CTRL_Z = 26;
    private SerialPort port;
    private Logger log;
    private Map<Boolean, SerialParams[]> serialParams;

    public ModemConnector(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 com \u043f\u043e\u0440\u0442\u0435");
        }
        this.port = port;
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None)});
        this.log = Logger.getLogger((String)"modem");
    }

    public List<String> send(String cmd, int timeout) throws ModemException {
        return this.send(cmd, '\r', timeout, true);
    }

    public List<String> send(String cmd, int timeout, boolean getAnswer) throws ModemException {
        return this.send(cmd, '\r', timeout, getAnswer);
    }

    public List<String> send(String cmd, char end, int timeout, boolean getAnswer) throws ModemException {
        LinkedList<String> res = new LinkedList<String>();
        try {
            cmd = cmd.toLowerCase(Locale.US);
            String cmd1 = cmd + end;
            this.log.debug((Object)(">>" + cmd));
            this.port.flush(Flush.RxTx);
            this.port.setTimeout(timeout);
            this.port.write(cmd1.getBytes("UTF-8"));
            ThreadUtil.sleep((long)40L);
            if (!getAnswer) {
                return null;
            }
            String data = null;
            while ((data = this.readLine(timeout)) != null) {
                if (cmd.equals(data)) {
                    this.log.debug((Object)"echo present");
                    continue;
                }
                if ("".equals(data)) {
                    this.log.debug((Object)"void str");
                    continue;
                }
                res.add(data);
                if (!data.matches("(OK|ERROR|NO CARRIER|BUSY|NO DIALTONE)")) continue;
            }
            this.log.debug((Object)("<<" + res));
            Thread.sleep(20L);
            return res;
        }
        catch (Exception ex) {
            throw new ModemException(ex);
        }
    }

    public List<String> sendUssd(String cmd, char end, int timeout) throws ModemException {
        LinkedList<String> res = new LinkedList<String>();
        try {
            cmd = cmd.toLowerCase(Locale.US);
            String cmd1 = cmd + end;
            this.port.flush(Flush.RxTx);
            this.port.setTimeout(timeout);
            this.log.debug((Object)(">>" + cmd1));
            this.port.write(cmd1.getBytes("UTF-8"));
            String data = null;
            while ((data = this.readLine(timeout)) != null) {
                if (cmd.equals(data)) {
                    this.log.debug((Object)"echo present");
                    continue;
                }
                if ("".equals(data)) {
                    this.log.debug((Object)"void str");
                    continue;
                }
                if (data.startsWith("^")) {
                    this.log.info((Object)("Skip " + data));
                    continue;
                }
                res.add(data);
                if (data.matches("OK")) {
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0445, \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0430\u0435\u043c \u0447\u0442\u0435\u043d\u0438\u0435");
                    continue;
                }
                if (data.matches("(ERROR|NO CARRIER|BUSY|NO DIALTONE)")) {
                    this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430, \u0432\u044b\u0445\u043e\u0434\u0438\u043c[" + data + "]"));
                    break;
                }
                if (!data.startsWith("+CUSD:")) continue;
                this.log.info((Object)"\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0442\u0438 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d. \u0412\u044b\u0445\u043e\u0434\u0438\u043c");
                break;
            }
            this.log.info((Object)("<<" + res));
            Thread.sleep(20L);
            return res;
        }
        catch (Exception ex) {
            throw new ModemException(ex);
        }
    }

    public List<String> sendSms(String cmd, String msg, int timeout) throws ModemException {
        LinkedList<String> res = new LinkedList<String>();
        try {
            cmd = cmd.toLowerCase(Locale.US) + '\r';
            this.port.setTimeout(timeout);
            this.port.write(cmd.getBytes("UTF-8"));
            String data = null;
            while ((data = this.readLine(timeout)) != null) {
                if (cmd.equals(data)) {
                    this.log.debug((Object)"echo present");
                    continue;
                }
                res.add(data);
                if (data.matches("(OK|ERROR|NO CARRIER|BUSY|NO DIALTONE)")) {
                    this.log.error((Object)"\u0412\u044b\u0445\u043e\u0434\u0438\u043c");
                    break;
                }
                if (!data.startsWith(">")) continue;
                this.log.error((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0442\u0435\u043a\u0441\u0442");
                msg = msg + '\r';
                this.port.write(msg.getBytes("UTF-8"));
                this.port.write((byte)26);
            }
            return res;
        }
        catch (Exception ex) {
            throw new ModemException(ex);
        }
    }

    private String readLine(int timeout) throws IOException {
        LinkedList<Byte> res;
        block1: {
            long start = System.currentTimeMillis();
            res = new LinkedList<Byte>();
            do {
                byte[] r = this.port.read(1);
                res.add(r[0]);
                this.log.debug((Object)ByteUtils.toString(res));
                int sz = res.size();
                if (sz >= 2 && (Byte)res.get(sz - 2) == 13 && (Byte)res.get(sz - 1) == 10) break block1;
                if (res.size() <= 400) continue;
                throw new IOException("Too long");
            } while (System.currentTimeMillis() - start <= (long)timeout);
            throw new IOException("Too slow");
        }
        String str = new String(ByteUtils.convert(res)).trim();
        this.log.debug((Object)("<<" + str));
        return str;
    }

    public synchronized void open() throws IOException {
        if (this.getAvailableParameters().length == 1) {
            this.port.putParams(this.getAvailableParameters()[0]);
        }
        this.port.open();
        this.port.setFlow(Flow.None);
    }

    public synchronized void close() {
        this.port.close();
    }

    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    public Map<Boolean, SerialParams[]> getSerialParams() {
        return this.serialParams;
    }
}

