/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.hopper.sch2;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.MoneyUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceInfoListener;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.hopper.BaseHopper;
import ru.softlogic.hardware.device.hopper.DispenseListener;
import ru.softlogic.hardware.device.hopper.HopperException;
import ru.softlogic.hardware.device.hopper.HopperStateListener;
import ru.softlogic.hardware.device.hopper.PayoutManager;
import ru.softlogic.hardware.device.hopper.PayoutOperation;
import ru.softlogic.hardware.device.hopper.algorithm.Denomination;
import ru.softlogic.hardware.device.hopper.algorithm.GreedyAlgorithmCalculator;
import ru.softlogic.hardware.device.hopper.algorithm.PayoutCalculator;
import ru.softlogic.hardware.device.hopper.sch2.Request;
import ru.softlogic.hardware.proto.cctalk.v2.BusyException;
import ru.softlogic.hardware.proto.cctalk.v2.CorePlusApi;
import ru.softlogic.hardware.proto.cctalk.v2.NakException;
import ru.softlogic.hardware.proto.cctalk.v2.payout.HopperApi;
import ru.softlogic.hardware.proto.cctalk.v2.payout.HopperStatus;
import ru.softlogic.hardware.proto.cctalk.v2.payout.PayoutApi;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;
import ru.softlogic.io.utils.SerialFmt;
import ru.softlogic.system.util.PathUtils;

public class Sch2Driver
extends BaseHopper {
    private SerialPort port;
    private CashBox box;
    private PayoutManager pm;
    private DeviceInfoListener infoListener;
    private HopperStateListener stateListener;
    private PayoutApi api;
    private PayoutCalculator pc;
    private Logger log;
    private boolean inited;
    private Map<CashUnit, Integer> boxUnits;
    private List<Request> queue;
    private Random rnd;
    private byte[] addresses;

    public Sch2Driver(SerialPort port, CashBox coinBox, PayoutManager pm, DeviceInfoListener infoListener, HopperStateListener stateListener) {
        if (port == null) {
            throw new NullPointerException("Port is needed");
        }
        if (coinBox == null) {
            throw new NullPointerException("CashBox is needed");
        }
        if (pm == null) {
            throw new NullPointerException("PayoutManager is needed");
        }
        if (infoListener == null) {
            throw new NullPointerException("DeviceInfoListener is needed");
        }
        if (stateListener == null) {
            throw new NullPointerException("HopperStateListener is needed");
        }
        this.port = port;
        this.box = coinBox;
        this.pm = pm;
        this.infoListener = infoListener;
        this.stateListener = stateListener;
        this.log = Logger.getLogger((String)"payout");
        this.api = new PayoutApi(port, this.log, 3);
        this.queue = new LinkedList<Request>();
        this.rnd = new Random();
        this.pc = new GreedyAlgorithmCalculator(0);
    }

    @Override
    public synchronized void clear(DispenseListener listener, int destination, Keeper keeper) throws HopperException, IOException {
        if (this.boxUnits == null || this.boxUnits.isEmpty()) {
            throw new HopperException("Hopper not inited[boxUnits]");
        }
        if (!this.queue.isEmpty()) {
            throw new HopperException("Hopper is busy");
        }
        this.log.info((Object)"===============================================================");
        this.log.info((Object)"Clean: current box");
        for (CashUnit cu : this.boxUnits.keySet()) {
            Integer count = (Integer)keeper.getCashUnits().get(cu);
            this.log.info((Object)("  " + cu + "->" + count));
            if (count == null || count <= 0) continue;
            this.log.info((Object)"  Added request");
            this.queue.add(new Request(this.boxUnits.get(cu), count, cu, listener, false));
        }
    }

    @Override
    public void add(MoneyUnit mu, int count) throws HopperException, IOException {
    }

    @Override
    public Keeper getKeeper() {
        return null;
    }

    @Override
    public synchronized void payout(PayoutOperation payoutOperation) throws HopperException, IOException {
        if (this.boxUnits == null || this.boxUnits.isEmpty()) {
            throw new HopperException("Hopper not inited[boxUnits]");
        }
        if (!this.queue.isEmpty()) {
            throw new HopperException("Hopper is busy");
        }
        this.log.info((Object)"===============================================================");
        this.log.info((Object)("Box: " + this.box.getKeeper()));
        HashMap<Denomination, Integer> presence = new HashMap<Denomination, Integer>();
        for (CashUnit cu : this.boxUnits.keySet()) {
            Integer count = (Integer)this.box.getKeeper().getCashUnits().get(cu);
            if (count == null || count <= 0) continue;
            presence.put(new Denomination(1, cu.getNominal().getBasicSum(), cu), count);
        }
        this.log.info((Object)("Presence: " + presence));
        Map<Denomination, Integer> po = this.pc.calculate(presence, payoutOperation.getSumPayout());
        this.log.info((Object)("Payout set: " + po));
        HashMap<CashUnit, Integer> units = new HashMap<CashUnit, Integer>();
        for (Denomination dn : po.keySet()) {
            units.put((CashUnit)dn.getObject(), po.get(dn));
        }
        this.log.info((Object)"Check the possibility of payout");
        if (this.pm.canGive(units, payoutOperation.getSumPayout(), payoutOperation.getSumInput())) {
            this.log.info((Object)"Payout allowed");
            this.log.info((Object)("Payout counts: " + po));
            if (po.isEmpty()) {
                payoutOperation.getListener().onProcess(0);
                payoutOperation.getListener().onResult(new Keeper());
            } else {
                for (Denomination dn : po.keySet()) {
                    this.log.info((Object)"  Added request");
                    CashUnit cu = (CashUnit)dn.getObject();
                    this.queue.add(new Request(this.boxUnits.get(cu), po.get(dn), cu, payoutOperation.getListener(), true));
                }
            }
        } else {
            this.log.info((Object)"Payout is not allowed");
            payoutOperation.getListener().onProcess(0);
            payoutOperation.getListener().onResult(new Keeper());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Thread start");
        this.log.info((Object)("Port: " + this.port.getName()));
        this.log.info((Object)("Params: " + this.port.getParams()));
        this.log.info((Object)"Driver: ccTalk/Payout/SCH2");
        byte[] rng = new byte[8];
        HashMap<Integer, byte[]> registers = new HashMap<Integer, byte[]>();
        HashMap<Integer, HopperStatus> states = new HashMap<Integer, HopperStatus>();
        int ioError = 0;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                try {
                    HopperApi ha;
                    if (!this.inited) {
                        this.init();
                    }
                    for (byte hId : this.addresses) {
                        ha = this.api.getHopperApi(hId);
                        HopperStatus hs = ha.requestHopperStatus();
                        HopperStatus lastHs = (HopperStatus)states.get(hId);
                        if (lastHs == null || !lastHs.equals(hs)) {
                            this.log.info((Object)("Change status on hopper: " + hId));
                            this.log.info((Object)("  " + hs));
                            states.put(Integer.valueOf(hId), hs);
                        }
                        byte[] reg = ha.testHopper();
                        byte[] lastReg = (byte[])registers.get(hId);
                        if (lastReg != null && Arrays.equals(reg, lastReg)) continue;
                        this.log.info((Object)("Change hopper registers: " + hId));
                        ha.printHopperRegisters(reg);
                        registers.put(Integer.valueOf(hId), reg);
                    }
                    HopperStatus hs = this.api.getHopperApi(3).requestHopperStatus();
                    if (hs.getPayoutCoinsRemaining() == 0 && !this.queue.isEmpty()) {
                        HashMap<CashUnit, Integer> disp = new HashMap<CashUnit, Integer>();
                        try {
                            for (Request req : this.queue) {
                                this.log.info((Object)("Process request: " + req));
                                ha = this.api.getHopperApi(req.getHopperId());
                                ha.resetDevice();
                                ha.enableHopper(true);
                                this.rnd.nextBytes(rng);
                                ha.pumpRNG(rng);
                                byte[] key = ha.requestCipherKey();
                                this.log.info((Object)("Dispence coins: " + req));
                                int eventId = ha.dispenseHopperCoins(key, req.getCount());
                                this.log.info((Object)("EventId: " + eventId));
                                HopperStatus ds = null;
                                while ((ds = ha.requestHopperStatus()).getPayoutCoinsRemaining() > 0) {
                                    this.log.info((Object)("Status: " + ds));
                                    disp.put(req.getCashUnit(), ds.getCoinsPaid());
                                    this.onProcess(disp, req.getListener());
                                    Thread.sleep(500L);
                                }
                                this.log.info((Object)("Status: " + ds));
                                disp.put(req.getCashUnit(), ds.getCoinsPaid());
                                this.onProcess(disp, req.getListener());
                                ha.enableHopper(false);
                            }
                        }
                        catch (Exception ex) {
                            this.log.error((Object)"Error on process payout", (Throwable)ex);
                        }
                        finally {
                            this.onComplete(disp, this.queue.get(0).getListener(), this.queue.get(0).isSub());
                            this.queue.clear();
                        }
                    }
                    ioError = 0;
                    this.processState();
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    this.log.error((Object)"I/O error", (Throwable)ex);
                    this.api.close();
                    Thread.sleep(1000L);
                    this.inited = false;
                    registers.clear();
                    states.clear();
                    if (ioError < 5) {
                        ++ioError;
                    }
                    if (ioError != 3) continue;
                    this.stateListener.onState(2);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)"Thread stop");
    }

    private void processState() throws IOException, NakException, BusyException, InterruptedException {
        HopperApi ha = this.api.getHopperApi(3);
        byte[] data = ha.testHopper();
        int s0 = BU.c((byte)data[0]);
        if ((s0 & 0x20) > 0) {
            this.stateListener.onState(3);
            ha.resetDevice();
            Thread.sleep(10000L);
        } else if ((s0 & 8) > 0) {
            this.stateListener.onState(3);
            ha.resetDevice();
            Thread.sleep(10000L);
        } else {
            this.stateListener.onState(0);
        }
    }

    private void onProcess(Map<CashUnit, Integer> dispenced, DispenseListener listener) {
        this.log.info((Object)("Payout process: " + dispenced));
        Sum sum = new Sum();
        for (CashUnit cu : dispenced.keySet()) {
            sum = sum.add(cu.getNominal().mul(dispenced.get(cu).intValue()));
        }
        this.log.info((Object)("Notify sum: " + sum));
        listener.onProcess(sum.getBasicSum());
    }

    private void onComplete(Map<CashUnit, Integer> dispenced, DispenseListener listener, boolean sub) {
        this.log.info((Object)("Payout complete: " + dispenced));
        Keeper kp = new Keeper();
        for (CashUnit cu : dispenced.keySet()) {
            kp.addCash(cu, dispenced.get(cu).intValue());
        }
        listener.onResult(kp);
        if (listener.isNeedSub()) {
            this.box.sub(kp);
        }
        listener = null;
    }

    private synchronized void init() throws IOException, InterruptedException, NakException, BusyException {
        this.api.open();
        this.addresses = this.api.addressPoll();
        for (int i = 0; i < 10 && (this.addresses == null || this.addresses.length == 0); ++i) {
            Thread.sleep(1000L);
            this.addresses = this.api.addressPoll();
        }
        if (this.addresses == null) {
            throw new IOException("Device go out");
        }
        DeviceInfo di = new DeviceInfo(DeviceType.SCH2Hopper);
        di.setPort(SerialFmt.format((SerialPort)this.port));
        this.log.info((Object)("Address poll: " + BU.toString((byte[])this.addresses)));
        String productCode = this.api.requestProductCode();
        String manufacterId = this.api.requestManufacterId();
        String equipmentCategory = this.api.requestEquipmentCategoryId();
        String buildCode = this.api.requestBuildCode();
        this.log.info((Object)("Product code: " + productCode));
        this.log.info((Object)("Equipment category: " + equipmentCategory));
        this.log.info((Object)("Manufacter: " + manufacterId));
        this.log.info((Object)("Build code: " + buildCode));
        CorePlusApi cApi = this.api.getCorePlusApi();
        int serial = cApi.requestSerialNumber();
        String firmware = cApi.requestSoftwareRevision();
        this.log.info((Object)("Serial number: " + serial));
        this.log.info((Object)("Software revision: " + firmware));
        di.setVendor(manufacterId);
        di.setModel(productCode + "/" + equipmentCategory);
        di.setSerial(Integer.toString(serial));
        di.setFirmware(firmware);
        this.infoListener.onDeviceInfo(di);
        this.inited = true;
        this.log.info((Object)"Current states:");
        for (byte a : this.addresses) {
            this.log.info((Object)("Line " + a));
            HopperApi ha = this.api.getHopperApi(a);
            this.log.info((Object)("  Variable set: " + ha.requestVariableSet()));
            ha.enableHopper(false);
            this.log.info((Object)("  Emergency stop: " + ha.emergencyStop()));
            ha.modifyVarialbeSet(50, 0, 30, false);
            ha.resetDevice();
        }
        this.log.info((Object)"Load hopper coins");
        try {
            List lines = FileUtils.readLines((File)new File(PathUtils.getAppHome() + "/resources/payout/hopper"));
            this.boxUnits = new HashMap<CashUnit, Integer>();
            for (String str : lines) {
                CashFactory cf;
                CashUnit cu;
                String[] paths = str.split(" ");
                if (paths.length != 3 || !paths[1].matches("^\\d+$") || !paths[2].matches("^\\d+$") || (cu = (cf = CashFactory.getInstance((String)paths[0])).getCoinUnitByNominal(new Sum(Integer.parseInt(paths[1])))) == null) continue;
                this.log.info((Object)("Added " + cu + "->" + paths[2]));
                this.boxUnits.put(cu, Integer.parseInt(paths[2]));
                this.log.info((Object)("  Current count: " + this.box.getKeeper().getCashUnits().get(cu)));
            }
            this.log.info((Object)("Final result: " + this.boxUnits));
        }
        catch (IOException ex) {
            this.log.error((Object)ex);
        }
    }

    @Override
    public void flowDownCoins(Keeper target, DispenseListener listener) throws HopperException, IOException {
    }

    @Override
    public boolean isFlowDownSupported() {
        return false;
    }
}

