/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.hopper;

import ru.softlogic.hardware.device.DeviceInfoListener;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.hopper.BaseHopper;
import ru.softlogic.hardware.device.hopper.HopperStateListener;
import ru.softlogic.hardware.device.hopper.PayoutManager;
import ru.softlogic.hardware.device.hopper.sch2.Sch2Driver;
import ru.softlogic.hardware.device.hopper.smart.SmartHopperDriver;
import ru.softlogic.io.serial.SerialPort;

public class HopperFactory {
    public static BaseHopper createInstance(DeviceType deviceType, SerialPort port, CashBox coinBox, CashBox flowDownCoinBox, PayoutManager pm, DeviceInfoListener infoListener, HopperStateListener stateListener) {
        if (deviceType == null || port == null) {
            return null;
        }
        switch (deviceType) {
            case SmartHopper: {
                return new SmartHopperDriver(port, coinBox, flowDownCoinBox, pm, infoListener, stateListener);
            }
            case SCH2Hopper: {
                return new Sch2Driver(port, coinBox, pm, infoListener, stateListener);
            }
        }
        return null;
    }
}

