/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cvd;

import java.io.IOException;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.hardware.search.Searchable;
import ru.softlogic.hardware.search.SearchableFactory;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class Cvd300Api
implements SerialDeviceApi {
    private final SerialPort port;

    public Cvd300Api(SerialPort port) {
        this.port = port;
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.Even)};
    }

    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            Searchable src = SearchableFactory.create((String)"cvd", (String)"cvd300");
            if (src != null) {
                for (SerialParams params : this.getAvailableParameters()) {
                    this.port.putParams(params);
                    try {
                        src.getSerialSearchable().search(this.port);
                        return null;
                    }
                    catch (NotFoundException notFoundException) {
                    }
                }
            } else {
                throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()) + "[\u041d\u0435\u0442 \u0432\u043d\u0435\u0448\u043d\u0438\u0445 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a]");
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.Cvd300;
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() {
    }
}

