/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cdm.f56.response.data;

public enum SensorState {
    Normal(2, 8),
    NeedCleaning(9, 12),
    NeedReplacement(13, 14);

    private final int minVal;
    private final int maxVal;

    private SensorState(int minVal, int maxVal) {
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    public int getMinVal() {
        return this.minVal;
    }

    public int getMaxVal() {
        return this.maxVal;
    }

    public static SensorState getSensorState(int sensorValue) {
        for (SensorState state : SensorState.values()) {
            if (sensorValue < state.getMinVal() || sensorValue > state.getMaxVal()) continue;
            return state;
        }
        return null;
    }
}

