/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cdm.f56.connector;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.cdm.f56.connector.CrcOperator;
import ru.softlogic.hardware.device.cdm.f56.connector.Sender;
import ru.softlogic.hardware.device.cdm.f56.request.Request;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;
import ru.softlogic.system.util.ThreadUtil;

public class F56Connection {
    private final int attempts = 5;
    private final SerialPort port;
    private final Logger log;

    public F56Connection(SerialPort port, Logger log) {
        this.port = port;
        this.log = log;
    }

    public synchronized byte[] sendCommand(Request request) throws IOException {
        for (int i = 0; i < 5; ++i) {
            try {
                return this.trySendCommand(request);
            }
            catch (IOException ex) {
                this.log.error((Object)"can't send command", (Throwable)ex);
                if (i == 4) continue;
                ThreadUtil.sleep((long)1000L);
                continue;
            }
        }
        throw new IOException("fail on sending command");
    }

    public synchronized byte[] trySendCommand(Request request) throws IOException {
        this.port.flush(Flush.RxTx);
        this.port.setTimeout(1500);
        this.port.write((byte)16);
        this.port.write((byte)5);
        this.log.debug((Object)">> DLE ENQ");
        this.waitDLE();
        int ans = this.port.readByte();
        if (ans != 6) {
            throw new IOException("Recieved NAK or wrong message");
        }
        this.log.debug((Object)"<< ACK");
        Sender sender = new Sender((BasePort)this.port);
        for (int j = 0; j < 20; ++j) {
            sender.send(request);
            this.log.debug((Object)(">> " + sender.getLastFrameLog()));
            this.waitDLE();
            int ack = this.port.readByte();
            if (ack != 6) {
                throw new IOException("Recieved NAK or wrong message");
            }
            this.log.debug((Object)"<< ACK");
            for (int i = 0; i < 5; ++i) {
                try {
                    this.port.setTimeout(20000);
                    byte[] data = this.readMessage();
                    this.log.debug((Object)("<< " + BU.toString((byte[])data)));
                    this.port.write((byte)16);
                    this.port.write((byte)6);
                    return data;
                }
                catch (IOException ex) {
                    this.log.error((Object)"Something wrong on reading anser", (Throwable)ex);
                    this.port.write((byte)16);
                    this.port.write((byte)21);
                    continue;
                }
            }
        }
        throw new IOException("Can't send command");
    }

    public byte[] readMessage() throws IOException {
        this.waitDLE();
        int ans = this.port.readByte();
        if (ans != 5) {
            throw new IOException("Expected ENQ, found: " + Integer.toHexString(ans));
        }
        this.log.debug((Object)"<< DLE ENQ");
        this.port.write((byte)16);
        this.port.write((byte)6);
        this.log.debug((Object)">> DLE ACK");
        CrcOperator crcOperator = new CrcOperator();
        this.waitDLE();
        ans = this.port.readByte();
        if (ans != 2) {
            throw new IOException("Expected STX, found: " + Integer.toHexString(ans));
        }
        this.log.debug((Object)"<< STX");
        byte[] len = this.port.read(2);
        crcOperator.operate(len[0]);
        crcOperator.operate(len[1]);
        int expectedLength = BU.csbe((byte[])len, (int)0);
        byte[] data = this.port.read(expectedLength);
        this.log.debug((Object)("<< " + BU.toString((byte[])len) + " " + BU.toString((byte[])data)));
        for (byte b : data) {
            crcOperator.operate(b);
        }
        this.waitDLE();
        if (this.port.readByte() != 3) {
            throw new IOException("Expected ETX, found: " + Integer.toHexString(ans));
        }
        this.log.debug((Object)"<< ETX");
        crcOperator.operate((byte)16);
        crcOperator.operate((byte)3);
        byte[] mess = new byte[expectedLength + 6];
        BU.ssbe((byte[])mess, (int)0, (int)expectedLength);
        System.arraycopy(data, 0, mess, 3, expectedLength);
        byte[] read = this.port.read(2);
        int crcexpected = BU.csle((byte[])read, (int)0);
        int factcrc = crcOperator.getCrc();
        if (crcexpected != factcrc) {
            throw new IOException("Wrong CRC");
        }
        return data;
    }

    private void waitDLE() throws IOException {
        int ans;
        do {
            if ((ans = this.port.readByte()) == 16) {
                this.log.debug((Object)"<< DLE");
                continue;
            }
            this.log.debug((Object)("<< garbage: " + String.format("%02x", ans)));
        } while (ans != 16);
    }
}

