/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cdm.f56;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.cdm.f56.connector.F56Connection;
import ru.softlogic.hardware.device.cdm.f56.request.Request;
import ru.softlogic.hardware.device.cdm.f56.request.command.BillCount;
import ru.softlogic.hardware.device.cdm.f56.request.command.Cancel;
import ru.softlogic.hardware.device.cdm.f56.request.command.DemandInit;
import ru.softlogic.hardware.device.cdm.f56.request.command.DeviceInfoRead;
import ru.softlogic.hardware.device.cdm.f56.request.command.StatusRequest;
import ru.softlogic.hardware.device.cdm.f56.request.command.TransportDemand;
import ru.softlogic.hardware.device.cdm.f56.response.ResponseBasic;
import ru.softlogic.hardware.device.cdm.f56.response.commandspecified.CountResponse;
import ru.softlogic.hardware.device.cdm.f56.response.commandspecified.DeviceInfoResponse;
import ru.softlogic.hardware.device.cdm.f56.response.commandspecified.InitResponse;
import ru.softlogic.hardware.device.cdm.f56.response.commandspecified.OprResponse;
import ru.softlogic.hardware.device.cdm.f56.response.commandspecified.VoidResponse;
import ru.softlogic.io.serial.SerialPort;

public class F56Api {
    private final SerialPort port;
    private final F56Connection conn;

    public F56Api(SerialPort port, Logger log) {
        this.port = port;
        this.conn = new F56Connection(port, log);
    }

    public ResponseBasic<InitResponse> initDevice(DemandInit request) throws IOException {
        byte[] resp = this.conn.sendCommand(request);
        ResponseBasic<InitResponse> initResp = new ResponseBasic<InitResponse>(new InitResponse());
        initResp.initData(resp);
        return initResp;
    }

    public ResponseBasic<CountResponse> countBills(BillCount request) throws IOException {
        byte[] resp = this.conn.sendCommand(request);
        ResponseBasic<CountResponse> countResp = new ResponseBasic<CountResponse>(new CountResponse());
        countResp.initData(resp);
        return countResp;
    }

    public ResponseBasic<OprResponse> transportBills(TransportDemand request) throws IOException {
        byte[] resp = this.conn.sendCommand(request);
        ResponseBasic<OprResponse> countResp = new ResponseBasic<OprResponse>(new OprResponse());
        countResp.initData(resp);
        return countResp;
    }

    public ResponseBasic<VoidResponse> getStatus() throws IOException {
        return this.sendCommandVoidResponse(new StatusRequest());
    }

    public ResponseBasic<VoidResponse> cancel() throws IOException {
        return this.sendCommandVoidResponse(new Cancel());
    }

    public ResponseBasic<DeviceInfoResponse> getDeviceInfo() throws IOException {
        byte[] resp = this.conn.sendCommand(new DeviceInfoRead());
        ResponseBasic<DeviceInfoResponse> deviceInfoResp = new ResponseBasic<DeviceInfoResponse>(new DeviceInfoResponse());
        deviceInfoResp.initData(resp);
        return deviceInfoResp;
    }

    private ResponseBasic<VoidResponse> sendCommandVoidResponse(Request request) throws IOException {
        byte[] resp = this.conn.sendCommand(request);
        ResponseBasic<VoidResponse> responseVoid = new ResponseBasic<VoidResponse>(new VoidResponse());
        responseVoid.initData(resp);
        return responseVoid;
    }

    public void open() throws IOException {
        this.port.open();
    }

    public void close() {
        this.port.close();
    }
}

