/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.status;

public enum ValidatorStatus {
    Ok(0, false),
    Init(-99, false),
    StackOverflow(1, true),
    StackOut(2, true),
    JammInHead(3, true),
    JammInStack(4, true),
    StackMotorError(5, true),
    TransportMotorError(6, true),
    AlignMotorError(7, true),
    InitStackError(8, true),
    OpticCanalError(9, true),
    MagneticCanalError(10, true),
    CapacitanceCanalError(11, true),
    ConnectionError(-2, true),
    Servicing(-8, true);

    private final int code;
    private final boolean error;

    private ValidatorStatus(int code, boolean error) {
        this.code = code;
        this.error = error;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isError() {
        return this.error;
    }

    public static ValidatorStatus getByCode(int code) {
        for (ValidatorStatus vs : ValidatorStatus.values()) {
            if (vs.code != code) continue;
            return vs;
        }
        return null;
    }
}

