/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.mdb;

import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.cashin.validator.mdb.NRIConnection;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.SerialPort;

public class MDBConnection {
    private final SerialPort port;
    private final NRIConnection connection;

    public MDBConnection(SerialPort port, Logger log) {
        this.port = port;
        this.connection = new NRIConnection(port, log);
    }

    public boolean init() throws IOException {
        return this.connection.sendModeCmd(10) == 46;
    }

    public byte[] reset() throws IOException {
        return this.connection.sendDataCmd(new int[]{48});
    }

    public byte[] status() throws IOException {
        return this.connection.sendDataCmd(new int[]{49});
    }

    public byte[] stacker() throws IOException {
        return this.connection.sendDataCmd(new int[]{54});
    }

    public byte[] security(int param1, int param2) throws IOException {
        return this.connection.sendDataCmd(new int[]{50, param1, param2});
    }

    public byte[] escrow(boolean flag) throws IOException {
        if (flag) {
            return this.connection.sendDataCmd(new int[]{53, 1});
        }
        return this.connection.sendDataCmd(new int[]{53, 0});
    }

    public byte poll() throws IOException {
        byte result = -1;
        byte[] ret = this.connection.sendDataCmd(new int[]{51});
        if (Arrays.equals(ret, NRIConnection.ACK)) {
            result = 0;
        } else if (ret.length >= 2) {
            result = ret[1];
        }
        return result;
    }

    public byte[] billType(int[] mask) throws IOException {
        int[] send = new int[mask.length + 1];
        send[0] = 52;
        for (int i = 1; i < mask.length + 1; ++i) {
            send[i] = mask[i - 1];
        }
        return this.connection.sendDataCmd(send);
    }

    public byte[] expansion() throws IOException {
        int[] send = new int[]{55, 0};
        return this.connection.sendDataCmd(send);
    }

    public void open() throws IOException {
        this.port.open();
        this.port.setFlow(Flow.None);
        this.port.setRTS(false);
        this.port.setDTR(false);
    }

    public void close() {
        this.port.close();
    }
}

