/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.mdb;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.hardware.device.cashin.validator.mdb.MDBConnection;
import ru.softlogic.hardware.device.cashin.validator.mdb.MDBInfo;
import ru.softlogic.hardware.device.cashin.validator.mdb.MDBStatus;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;
import ru.softlogic.system.util.ArrayUtils;

public class MDBApi
implements ValidatorApi {
    private Map<Boolean, SerialParams[]> serialParams;
    private SerialPort serialPort;
    private MDBConnection mdbConnection;
    private boolean open;

    public MDBApi(SerialPort serialPort, Logger log) {
        if (serialPort == null) {
            throw new IllegalArgumentException("Needs SerialPort");
        }
        if (log == null) {
            throw new IllegalArgumentException("Needs Logger");
        }
        this.serialPort = serialPort;
        this.mdbConnection = new MDBConnection(serialPort, log);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None)});
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public void setSerialPort(SerialPort serialPort) {
        this.serialPort = serialPort;
    }

    @Override
    public void test() throws IOException {
        this.open();
        this.reset();
        this.close();
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        this.open();
        MDBInfo inf = this.info();
        this.close();
        return new ValidatorInfo(inf.getCompany() + " " + inf.getModel());
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.serialPort.putParams(params);
                this.mdbConnection.open();
                if (!this.mdbConnection.init()) {
                    throw new Exception();
                }
                this.reset();
                DeviceType deviceType = null;
                return deviceType;
            }
            catch (Exception exception) {
            }
            finally {
                this.mdbConnection.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.Mdb;
    }

    @Override
    public void open() throws IOException {
        if (!this.open) {
            if (this.getAvailableParameters().length == 1) {
                this.serialPort.putParams(this.getAvailableParameters()[0]);
            }
            this.mdbConnection.open();
            for (int i = 0; i < 3; ++i) {
                this.open = this.mdbConnection.init();
                if (this.open) break;
            }
            if (!this.open) {
                throw new IOException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            }
        }
    }

    @Override
    public void close() {
        if (this.open) {
            this.open = false;
            this.mdbConnection.close();
        }
    }

    public final void reset() throws IOException {
        this.mdbConnection.reset();
    }

    public final void enable() throws IOException {
        this.open();
        this.mdbConnection.init();
        int[] mask = new int[]{255, 255, 255, 255};
        this.mdbConnection.billType(mask);
    }

    public final void disable() throws IOException {
        int[] mask = new int[]{0, 0, 0, 0};
        this.mdbConnection.billType(mask);
    }

    public final void stackCash() throws IOException {
        this.mdbConnection.escrow(true);
    }

    public final void returnCash() throws IOException {
        this.mdbConnection.escrow(false);
    }

    public final MDBStatus poll() throws IOException {
        this.open();
        byte ret = this.mdbConnection.poll();
        if ((ret & 0x80) > 0) {
            int idBill = ret & 0xF;
            int billRouting = ret & 0x70;
            return new MDBStatus(128, idBill, billRouting >>= 4);
        }
        return new MDBStatus(ret);
    }

    public final void securety(boolean on) throws IOException {
        if (on) {
            this.mdbConnection.security(255, 255);
        } else {
            this.mdbConnection.security(0, 0);
        }
    }

    public final void status() throws IOException {
        this.mdbConnection.status();
    }

    public final MDBInfo info() throws IOException {
        byte[] ret = this.mdbConnection.expansion();
        LinkedList<Byte> list = new LinkedList<Byte>();
        for (byte b : ret) {
            if (b == 1) break;
            if (b == 0 || b == 32) continue;
            list.add(b);
        }
        String version = BU.toHex((byte)((Byte)list.get(list.size() - 2))).replace("0x", "").replace(" ", "");
        version = version + BU.toHex((byte)((Byte)list.get(list.size() - 1))).replace("0x", "").replace(" ", "");
        list.remove(list.size() - 1);
        list.remove(list.size() - 1);
        String source = new String(BU.convert(list));
        MDBInfo result = new MDBInfo();
        result.setSoftware(version);
        result.setCompany(source.substring(0, 3));
        result.setSerial(source.substring(3, 15));
        result.setModel(source.substring(15));
        return result;
    }
}

