/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.mdb;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.BillTableResource;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.mdb.MDBApi;
import ru.softlogic.io.serial.SerialPort;

public class Driver
extends Validator {
    private final DeviceInfo info = new DeviceInfo(DeviceType.Ccnet);
    private final MDBApi api;
    private Map<Integer, CashUnit> billTable;

    public Driver(SerialPort port, String currency) {
        super("cashin");
        this.info.setVendor("CashCode");
        this.info.setPort(port.getName());
        this.log.debug((Object)"Create MDBDriver instance");
        this.api = new MDBApi(port, this.log);
        this.log.debug((Object)"MDBApi created succsessfully");
        this.billTableLoad(currency);
        this.log.info((Object)("\u0412\u0430\u043b\u044e\u0442\u0430 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430: " + currency));
    }

    protected final void billTableLoad(String currency) {
        try {
            BillTableResource resource = (BillTableResource)Class.forName("ru.softlogic.hardware.device.cashin.validator.mdb.BillTableResource_" + currency).newInstance();
            this.billTable = resource.getBillTable();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Driver " + this.getClass().getName() + " doesn't support currency " + currency, ex);
        }
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    @Override
    public void enable(Set<CashUnit> cashUnits, Set<CashUnit> coinUnits) {
        try {
            this.log.debug((Object)"Try to enable validator");
            this.mutex.lock();
            try {
                this.api.enable();
            }
            catch (IOException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0430", (Throwable)ex);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.enable = true;
        this.mutex.unlock();
        this.log.debug((Object)"Validator enabled");
    }

    @Override
    public void disable() {
        try {
            this.log.debug((Object)"Try to disable validator");
            this.mutex.lock();
            try {
                this.api.disable();
            }
            catch (IOException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0430", (Throwable)ex);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.enable = false;
        this.mutex.unlock();
        this.log.debug((Object)"Validator disabled");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

