/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.itl;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.hardware.proto.essp.Crc16;
import ru.softlogic.hardware.proto.essp.Nv200Api;
import ru.softlogic.hardware.proto.essp.Result;
import ru.softlogic.hardware.proto.essp.SSPApi;
import ru.softlogic.hardware.proto.essp.SSPException;
import ru.softlogic.hardware.proto.essp.SSPLayer;
import ru.softlogic.hardware.proto.essp.ValidatorSetup;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;

public class AppNv200Api
implements ValidatorApi {
    private SerialPort port;
    private SerialParams[] params;
    private SSPApi api;
    private final Logger log = Logger.getLogger((String)"payout");

    public AppNv200Api(SerialPort port) {
        if (port == null) {
            throw new NullPointerException("Port");
        }
        this.params = new SerialParams[]{new SerialParams(9600)};
        this.port = port;
        this.api = new SSPApi(port, 0, this.log);
    }

    @Override
    public void test() throws IOException {
        this.api.reset();
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        return new ValidatorInfo(this.api.getFirmware().getData());
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams sp : this.getAvailableParameters()) {
                this.port.putParams(sp);
                try {
                    DeviceType deviceType;
                    this.port.open();
                    this.api.sync();
                    Result<Integer> res = this.api.getUnitType();
                    if (res.isOk()) {
                        if (res.getData() == 3) {
                            deviceType = DeviceType.SmartHopper;
                            return deviceType;
                        }
                        if (res.getData() == 6) {
                            deviceType = DeviceType.SmartPayout;
                            return deviceType;
                        }
                        if (res.getData() == 0) {
                            Nv200Api nva = new Nv200Api(new SSPLayer(this.port, new Crc16(), this.log), 0, 6, this.log);
                            ValidatorSetup set = nva.getDeviceSetup();
                            if (set.getProto() == 3) {
                                DeviceType deviceType2 = DeviceType.SspValidator;
                                return deviceType2;
                            }
                            DeviceType deviceType3 = DeviceType.ItlValidator;
                            return deviceType3;
                        }
                    }
                    deviceType = null;
                    return deviceType;
                }
                catch (IOException | SSPException ex) {
                    this.log.info((Object)"Fail looking", (Throwable)ex);
                }
                finally {
                    this.port.close();
                }
            }
        }
        throw new NoSuchDeviceException("Device on port " + this.port.getName() + " is not ITL device");
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.NV200;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }
}

