/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.id003;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.hardware.device.cashin.validator.id003.Id003Connection;
import ru.softlogic.hardware.device.cashin.validator.id003.Id003Info;
import ru.softlogic.hardware.device.cashin.validator.id003.Id003Status;
import ru.softlogic.hardware.device.cashin.validator.id003.WrongCommandException;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;
import ru.softlogic.system.util.ArrayUtils;

public class Id003Api
implements ValidatorApi {
    private Map<Boolean, SerialParams[]> serialParams;
    private Id003Connection id003Connection;
    private SerialPort serialPort;

    public Id003Api(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = serialPort;
        this.id003Connection = new Id003Connection(serialPort);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.Even)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.Even)});
    }

    public SerialPort getPort() {
        return this.serialPort;
    }

    @Override
    public final SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DeviceType look(boolean preferred) throws NoSuchDeviceException {
        this.id003Connection.setAttempts(1);
        this.id003Connection.setIoTimeout(750);
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.serialPort.putParams(params);
                this.id003Connection.open();
                this.reset();
                DeviceType deviceType = null;
                return deviceType;
            }
            catch (Exception exception) {
            }
            finally {
                this.id003Connection.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public final DeviceType getDeviceType() {
        return DeviceType.Id003;
    }

    @Override
    public final void open() throws IOException {
        this.id003Connection.open();
    }

    @Override
    public final void close() {
        this.id003Connection.close();
    }

    public final Id003Status poll() throws IOException {
        byte[] data = this.id003Connection.sendCommand((byte)17);
        Id003Status result = new Id003Status();
        if (data.length >= 1) {
            result.setStatus(data[0] & 0xFF);
        }
        if (data.length >= 2) {
            result.setSubStatus(data[1] & 0xFF);
        }
        return result;
    }

    public final void reset() throws IOException {
        byte[] res = this.id003Connection.sendCommand((byte)64);
        if (res.length != 1 || res[0] != 80) {
            throw new IOException("Wrong answer format");
        }
    }

    public final Id003Info identification() throws IOException {
        byte[] data = this.id003Connection.sendCommand((byte)-120);
        String str = "";
        for (int i = 0; i < data.length; ++i) {
            char symbol = (char)data[i];
            str = str + (BU.isStringChar((char)symbol) ? symbol : (char)'?');
        }
        Id003Info info = new Id003Info();
        String[] paths = str.split(" (?![Vv])");
        if (paths.length == 4) {
            String[] paths2;
            Matcher m2 = Pattern.compile(".*\\((.*{3})\\)-?(.*)").matcher(paths[0]);
            if (m2.find()) {
                info.setCountry(m2.group(1));
                String[] paths1 = m2.group(2).split("-");
                if (paths1.length == 2) {
                    info.setModelNo(paths1[0]);
                    info.setStackerType(paths1[1]);
                } else {
                    info.setModelNo(paths1[0]);
                }
            }
            if ((paths2 = paths[1].split(" ?(v|V)")).length == 2) {
                info.setInterfaceType(paths2[0]);
                info.setSoftwareVersion(paths2[1]);
            }
            info.setSoftwareBuild(paths[2]);
        }
        return info;
    }

    public final String getBootVersion() throws IOException {
        byte[] data = this.id003Connection.sendCommand((byte)-119);
        String str = "";
        for (int i = 1; i < data.length; ++i) {
            char symbol = (char)data[i];
            str = str + (ByteUtils.isStringChar(symbol) ? symbol : (char)'?');
        }
        return str;
    }

    public final void disable() throws IOException {
        byte mask = 1;
        this.id003Connection.sendCommand((byte)-61, new byte[]{mask});
    }

    public final void enable() throws IOException {
        byte mask = 0;
        this.id003Connection.sendCommand((byte)-61, new byte[]{mask});
    }

    public final void returnCash() throws IOException {
        this.id003Connection.sendCommand((byte)67);
    }

    public final void stackCash() throws IOException {
        this.id003Connection.sendCommand((byte)65);
    }

    public final void enableBillTypes() throws IOException {
        byte[] data = new byte[]{0, 0};
        byte[] data0 = this.id003Connection.sendCommand((byte)-64, data);
    }

    public final void secure() throws IOException {
        byte[] data = new byte[]{0, 0};
        this.id003Connection.sendCommand((byte)-63, data);
    }

    @Override
    public void test() throws IOException {
        this.reset();
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        Id003Info info = this.identification();
        return new ValidatorInfo(info.getSoftwareVersion() + " " + info.getSoftwareBuild());
    }

    public final byte getActiveCountry() throws IOException {
        try {
            byte[] res = this.id003Connection.sendCommand2((byte)-117, new byte[]{1});
            return res[2];
        }
        catch (WrongCommandException ex) {
            return 0;
        }
    }

    public final byte[] getSupportCountries() throws IOException {
        try {
            byte[] res = this.id003Connection.sendCommand2((byte)-117, new byte[]{2});
            byte[] r = new byte[res.length - 2];
            System.arraycopy(res, 2, r, 0, r.length);
            return r;
        }
        catch (WrongCommandException ex) {
            return new byte[0];
        }
    }
}

