/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ict004;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.BillTableResource;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.ict004.Ict004Api;
import ru.softlogic.hardware.device.cashin.validator.ict004.IctStatus;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.io.serial.SerialPort;

public class Driver
extends Validator {
    private final Ict004Api api;
    private final DeviceInfo info = new DeviceInfo(DeviceType.Ict004);
    private Map<Integer, CashUnit> billTable;

    public Driver(SerialPort conn, String currency) {
        super("cashin");
        this.info.setVendor("ICT");
        this.info.setModel("ICT004");
        this.info.setPort(conn.getName());
        this.api = new Ict004Api(conn);
        this.billTableLoad(currency);
    }

    protected final void billTableLoad(String currency) {
        BillTableResource resource = null;
        try {
            resource = (BillTableResource)Class.forName("ru.softlogic.hardware.device.cashin.validator.ict004.BillTableResource_" + currency).newInstance();
            this.billTable = resource.getBillTable();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Driver " + this.getClass().getName() + " not support currency " + currency, ex);
        }
    }

    @Override
    public void enable(Set<CashUnit> cashUnits, Set<CashUnit> coinUnits) {
        try {
            this.log.debug((Object)"Try to enable validator");
            this.mutex.lock();
            try {
                this.api.enable();
            }
            catch (IOException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0430", (Throwable)ex);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.enable = true;
        this.mutex.unlock();
        this.log.debug((Object)"Validator enabled");
    }

    @Override
    public void disable() {
        try {
            this.log.debug((Object)"Try to disable validator");
            this.mutex.lock();
            try {
                this.api.disable();
            }
            catch (IOException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0430", (Throwable)ex);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.enable = false;
        this.mutex.unlock();
        this.log.debug((Object)"Validator disabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.debug((Object)"Start");
        IctStatus lastStatus = null;
        IctStatus currStatus = null;
        this.notifyStatus(ValidatorStatus.Init);
        this.notifyStatus(ValidatorStatus.Ok);
        try {
            this.api.open();
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (lastStatus == null) {
                        this.log.info((Object)"\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u044e \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440");
                        this.api.reset();
                        this.api.handleResponse();
                        this.api.disable();
                        this.notifyStatus(ValidatorStatus.Ok);
                    }
                    Thread.sleep(100L);
                    currStatus = this.api.getStatus();
                    if (currStatus == null) {
                        if (lastStatus != null) continue;
                        lastStatus = new IctStatus(0, 0);
                        continue;
                    }
                    this.log.debug((Object)("Current status = " + currStatus));
                    switch (currStatus.getStatus()) {
                        case 128: {
                            this.log.debug((Object)"Power supply on");
                            if (currStatus.getSubStatus() == 143) {
                                this.log.debug((Object)"\u041e\u043f\u043e\u0432\u0435\u0449\u0430\u044e \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a \u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u044c\u044e \u041f\u041e");
                                this.api.handleResponse();
                                this.notifyStatus(ValidatorStatus.Init);
                                break;
                            }
                            this.log.debug((Object)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0441\u0443\u0431\u0441\u0442\u0430\u0442\u0443\u0441 \u0443 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f 0x80");
                            break;
                        }
                        case 129: {
                            this.notifyEvent(Event.Insert);
                            this.notifyStatus(ValidatorStatus.Ok);
                            if (this.cashStorage != null) {
                                CashUnit bill = this.billTable.get(currStatus.getSubStatus());
                                if (bill != null && this.cashStorage.cashPermit(bill)) {
                                    try {
                                        this.mutex.lock();
                                        this.log.info((Object)"\u0414\u0430\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u0443 \u043d\u0430 \u0443\u043a\u043b\u0430\u0434\u043a\u0443");
                                        this.api.stackCash();
                                        this.log.info((Object)"\u041e\u0436\u0438\u0434\u0430\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u0438\u0435\u043c\u0430");
                                        IctStatus res = this.api.getStackResult();
                                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u0438\u0435\u043c\u0430: " + res));
                                        if (res != null) {
                                            switch (res.getStatus()) {
                                                case 16: {
                                                    this.log.info((Object)"\u041a\u0443\u043f\u044e\u0440\u0430 \u043f\u0440\u0438\u043d\u044f\u0442\u0430");
                                                    this.cashStorage.addCash(bill);
                                                    this.notifyCash(bill);
                                                    break;
                                                }
                                                case 17: {
                                                    this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u0438\u0435\u043c\u0435 \u043a\u0443\u043f\u044e\u0440\u044b");
                                                    break;
                                                }
                                                default: {
                                                    this.log.error((Object)("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f \u0434\u0440\u0443\u0433\u043e\u0439 \u0441\u0442\u0430\u0442\u0443\u0441. \u041f\u043e\u043b\u0443\u0447\u0435\u043d " + res));
                                                    break;
                                                }
                                            }
                                            break;
                                        }
                                        this.log.error((Object)"\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442 \u0437\u0430 60 \u0441\u0435\u043a");
                                        break;
                                    }
                                    catch (IOException ex) {
                                        throw ex;
                                    }
                                    finally {
                                        this.mutex.unlock();
                                    }
                                }
                                this.log.error((Object)"Stack cash is not permit");
                                this.api.returnCash();
                                break;
                            }
                            this.log.error((Object)"CashStorage is null, Stack cash is not permit");
                            this.api.returnCash();
                        }
                    }
                    if (currStatus.equals(lastStatus)) continue;
                    switch (currStatus.getStatus()) {
                        case 32: {
                            this.log.debug((Object)"Response motor failure");
                            this.notifyStatus(ValidatorStatus.StackMotorError);
                            break;
                        }
                        case 33: {
                            this.log.debug((Object)"Response checkSum error");
                            this.notifyStatus(ValidatorStatus.InitStackError);
                            break;
                        }
                        case 34: {
                            this.log.debug((Object)"Response bill jam");
                            this.notifyStatus(ValidatorStatus.JammInHead);
                            break;
                        }
                        case 35: {
                            this.log.debug((Object)"Response bill remove");
                            break;
                        }
                        case 36: {
                            this.log.debug((Object)"Response stacker open");
                            this.notifyStatus(ValidatorStatus.StackOut);
                            this.log.debug((Object)"Response stacker init");
                            this.notifyStatus(ValidatorStatus.Init);
                            break;
                        }
                        case 37: {
                            this.log.debug((Object)"Response sensor problem");
                            this.notifyStatus(ValidatorStatus.OpticCanalError);
                            break;
                        }
                        case 38: {
                            this.log.debug((Object)"Communication failure, disable bill acceptor to inhibit status");
                            break;
                        }
                        case 39: {
                            this.log.debug((Object)"Response bill fish");
                            break;
                        }
                        case 40: {
                            this.log.debug((Object)"Response stacker problem");
                            this.notifyStatus(ValidatorStatus.InitStackError);
                            break;
                        }
                        case 41: {
                            this.log.debug((Object)"Response bill reject");
                            this.notifyEvent(Event.Insert);
                            this.notifyEvent(Event.CommonReject);
                            break;
                        }
                        case 42: {
                            this.log.debug((Object)"Response invalid command");
                            break;
                        }
                        case 46: {
                            this.log.debug((Object)"Response reserved");
                            break;
                        }
                        case 47: {
                            this.log.debug((Object)"Response when error status is exclusion");
                            break;
                        }
                        case 62: 
                        case 94: 
                        case 128: 
                        case 129: {
                            break;
                        }
                        default: {
                            this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 " + currStatus));
                        }
                    }
                    lastStatus = currStatus;
                }
                catch (IOException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                    this.api.close();
                    this.api.open();
                    lastStatus = null;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (IOException ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        finally {
            this.api.close();
        }
        this.log.debug((Object)"Stop");
    }

    public String toString() {
        return "ICT004";
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }
}

