/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.gpt22;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.BillTableResource;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.gpt22.Gpt22Api;
import ru.softlogic.hardware.device.cashin.validator.gpt22.GptStatus;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Driver
extends Validator {
    private final Gpt22Api api;
    private final DeviceInfo info;
    private boolean safeState;
    private final Object eSync = new Object();
    private final Object sSync = new Object();
    private Map<Integer, CashUnit> billTable;

    public Driver(SerialPort port, String currency) {
        super("cashin");
        this.api = new Gpt22Api(port, this.log);
        this.billTableLoad(currency);
        this.info = new DeviceInfo(DeviceType.GPT22);
        this.info.setPort(port.getName());
    }

    protected final void billTableLoad(String currency) {
        try {
            BillTableResource resource = (BillTableResource)Class.forName("ru.softlogic.hardware.device.cashin.validator.gpt22.BillTableResource_" + currency).newInstance();
            this.billTable = resource.getBillTable();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Driver " + this.getClass().getName() + " not support currency " + currency, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        GptStatus lastStatus = null;
        boolean canStake = false;
        this.notifyStatus(ValidatorStatus.Init);
        this.notifyStatus(ValidatorStatus.Ok);
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.sleep(250);
                    try {
                        CashUnit bill;
                        if (lastStatus == null) {
                            this.log.info((Object)"Try to open port");
                            this.api.open();
                            this.init();
                        }
                        if (this.isEnabled()) {
                            this.api.setBillEnables(65535);
                        } else {
                            this.api.setBillEnables(0);
                        }
                        GptStatus status = this.api.requestStatus();
                        if (!status.equals(lastStatus)) {
                            this.api.debugData(status);
                        }
                        if (status.isPowerOn() && (lastStatus == null || !lastStatus.isPowerOn())) {
                            this.log.info((Object)"Power Up");
                        }
                        if (status.isIdle() && (lastStatus == null || !lastStatus.isIdle())) {
                            this.log.info((Object)"Idling");
                            this.notifyStatus(ValidatorStatus.Ok);
                        }
                        if (status.isAccepting() && (lastStatus == null || !lastStatus.isAccepting())) {
                            this.log.info((Object)"Accepting");
                            this.notifyEvent(Event.Insert);
                        }
                        if (status.isEscrow() && (lastStatus == null || !lastStatus.isEscrow())) {
                            this.notifySafeState(false);
                            this.log.info((Object)"Escrow position");
                            bill = this.billTable.get(status.getBillType());
                            if (bill != null && this.cashStorage.cashPermit(bill)) {
                                this.log.info((Object)"Stack bill...");
                                canStake = true;
                                this.api.acceptBill();
                            } else {
                                this.api.returnBill();
                                this.notifySafeState(true);
                            }
                        }
                        if (status.isStacking() && (lastStatus == null || !lastStatus.isStacking())) {
                            this.log.info((Object)"Stacking");
                        }
                        if (status.isBillStacked() && (lastStatus == null || !lastStatus.isBillStacked())) {
                            this.log.info((Object)"Stacked");
                            this.notifyStatus(ValidatorStatus.Ok);
                            if (canStake) {
                                bill = this.billTable.get(status.getBillType());
                                this.cashStorage.addCash(bill);
                                this.notifyCash(bill);
                                canStake = false;
                            } else {
                                this.log.error((Object)"Flag CanStack is not set, Can't add bill");
                            }
                            this.notifySafeState(true);
                        }
                        if (status.isIdle() && (lastStatus == null || !lastStatus.isIdle())) {
                            this.log.info((Object)"Idling");
                            this.notifyStatus(ValidatorStatus.Ok);
                        }
                        if (status.isReturning() && (lastStatus == null || !lastStatus.isReturning())) {
                            this.log.info((Object)"Returning");
                        }
                        if (status.isBillReturned() && (lastStatus == null || !lastStatus.isBillReturned())) {
                            this.log.info((Object)"Returned");
                        }
                        if (status.isCheat() && (lastStatus == null || !lastStatus.isCheat())) {
                            this.log.info((Object)"Cheated");
                        }
                        if (status.isRejecting() && (lastStatus == null || !lastStatus.isRejecting())) {
                            this.log.info((Object)("Rejected, code: " + BU.toHex((int)status.getRejectingCode()) + ", cause: " + this.api.getRejectMessage(status.getRejectingCode())));
                            this.notifyEvent(Event.TransportErrorReject);
                        }
                        if (status.isStackerJamm() && (lastStatus == null || !lastStatus.isStackerJamm())) {
                            this.log.info((Object)"Jammed");
                            this.notifyStatus(ValidatorStatus.JammInHead);
                        }
                        if (status.isStackerFull() && (lastStatus == null || !lastStatus.isStackerFull())) {
                            this.log.info((Object)"StackerFull");
                            this.notifyStatus(ValidatorStatus.StackOverflow);
                        }
                        if (status.isStackerOff() && (lastStatus == null || !lastStatus.isStackerOff())) {
                            this.log.info((Object)"Stack out");
                            this.notifyStatus(ValidatorStatus.StackOut);
                        }
                        if (status.isPowerOn() && (lastStatus == null || !lastStatus.isPowerOn())) {
                            this.log.info((Object)"Power on");
                        }
                        if (status.isUpWithBill() && (lastStatus == null || !lastStatus.isUpWithBill())) {
                            this.log.info((Object)"Power on with bill");
                        }
                        lastStatus = status;
                    }
                    catch (IOException ex) {
                        this.log.error((Object)ex, (Throwable)ex);
                        this.api.close();
                        this.sleep(500);
                        lastStatus = null;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    private void init() throws IOException, InterruptedException {
        this.log.info((Object)"------------------------------------------------------------------------");
        this.log.info((Object)"Reset");
        this.api.reset();
        Thread.sleep(4000L);
        this.log.info((Object)"Success");
        this.api.setMode(3);
        this.api.setStackerRequire(false);
        this.api.setInhibit(false);
        this.api.setBillEnables(0);
        this.log.info((Object)"--------------------------");
        this.log.info((Object)"Bill validator info:");
        this.info.setVendor("GPT");
        this.info.setModel("Protocol v2.2");
        this.info.setFirmware(this.api.requestProgramRevision());
        this.info.setSerial(this.api.requestSerial());
        this.log.info((Object)("Serial: " + this.info.getSerial()));
        this.log.info((Object)("Programm revision: " + this.info.getFirmware()));
        this.log.info((Object)"---");
    }

    @Override
    public void enable(Set<CashUnit> cashUnits, Set<CashUnit> coinUnits) {
        try {
            this.log.info((Object)"-------------------------------------------------------------------");
            this.log.info((Object)"Enable cash acceptor");
            this.mutex.lock();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.enable) {
            throw new IllegalStateException("Device already enabled");
        }
        this.enable = true;
        this.enable = true;
        this.cashUnits = cashUnits;
        this.coinUnits = coinUnits;
        this.mutex.unlock();
        this.log.info((Object)"Cash acceptor is enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        try {
            this.log.info((Object)"Disable cash acceptor");
            this.mutex.lock();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        Object object = this.sSync;
        synchronized (object) {
            if (!this.safeState) {
                try {
                    this.sSync.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.enable = false;
        }
        this.mutex.unlock();
        object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
        this.log.info((Object)"Cash acceptor is disabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySafeState(boolean safe) {
        if (this.safeState != safe) {
            this.log.info((Object)("Safe changed: " + safe));
            this.safeState = safe;
            Object object = this.sSync;
            synchronized (object) {
                this.sSync.notifyAll();
            }
        }
    }
}

