/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ebds;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.cashin.validator.ebds.BlockSearcher;
import ru.softlogic.hardware.device.cashin.validator.ebds.EbdsApi;

public class FastBlockSearcher
extends BlockSearcher {
    private boolean shortLastBlock = false;

    public FastBlockSearcher(EbdsApi api, Logger log) {
        super(api, log);
        this.blockLength = 64;
    }

    @Override
    public void setFile(RandomAccessFile file) throws IOException {
        super.setFile(file);
        if (this.raf.length() > (long)(this.blockCount * this.blockLength)) {
            ++this.blockCount;
            this.shortLastBlock = true;
        }
        this.log.info((Object)("Using short last block: " + this.shortLastBlock));
    }

    @Override
    public byte[] getBlock(int blockNumber) throws IOException {
        byte[] data;
        if (this.shortLastBlock && blockNumber == this.blockCount - 1) {
            data = new byte[32];
            this.raf.seek(blockNumber * this.blockLength);
            this.raf.read(data, 0, 32);
        } else {
            data = super.getBlock(blockNumber);
        }
        return data;
    }

    @Override
    protected int downloadData(byte[] data, int blockNumber) throws IOException {
        return this.api.fastBlockDownloadFirmware(data, blockNumber);
    }
}

