/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ebds;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.hardware.device.cashin.validator.ebds.EbdsConnection;
import ru.softlogic.hardware.device.cashin.validator.ebds.EbdsStatus;
import ru.softlogic.hardware.device.cashin.validator.ebds.Note;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;

public class EbdsApi
implements ValidatorApi {
    private static final byte[] extOn = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] extOff = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] extCurrent;
    private SerialPort port;
    private EbdsConnection conn;
    private SerialParams[] params;
    private byte[] data;
    private Logger log;

    public EbdsApi(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.port = port;
        this.conn = new EbdsConnection(port);
        this.params = new SerialParams[]{new SerialParams(9600, DataBits.Seven, StopBits.One, Parity.Even)};
        this.data = new byte[3];
        this.data[0] = 0;
        this.data[1] = 28;
        this.data[2] = 16;
        extCurrent = extOff;
        this.log = Logger.getLogger((String)"cashin");
        this.log.setAdditivity(false);
    }

    public void enable() throws IOException {
        if (this.data[0] == 0) {
            this.data[0] = -1;
            extCurrent = extOn;
            this.sendExtendedMessage(3, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
        }
    }

    public void disable() throws IOException {
        if (this.data[0] != 0) {
            this.data[0] = 0;
            extCurrent = extOff;
            this.sendExtendedMessage(3, new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
        }
    }

    public void unsetCashPolicy() {
        this.data[1] = (byte)(this.data[1] & 0xFFFFFFDF);
        this.data[1] = (byte)(this.data[1] & 0xFFFFFFBF);
    }

    public void stackCash() throws IOException {
        this.data[1] = (byte)(this.data[1] | 0x20);
        this.data[1] = (byte)(this.data[1] & 0xFFFFFFBF);
        this.sendOmnibusMessage();
    }

    public void returnCash() throws IOException {
        this.data[1] = (byte)(this.data[1] | 0x40);
        this.data[1] = (byte)(this.data[1] & 0xFFFFFFDF);
        this.sendOmnibusMessage();
    }

    public EbdsStatus poll() throws IOException {
        EbdsStatus status;
        try {
            status = this.sendOmnibusMessage();
        }
        catch (EbdsConnection.NAKException ex) {
            status = this.parceAnswer(ex.getReply());
        }
        return status;
    }

    public String getAccessorType() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 4}, null);
        return this.parceAns(ans, 21);
    }

    public String getAccessorSerialNumber() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 5}, null);
        return this.parceAns(ans, 21);
    }

    public String getAccessorBootPartNumner() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 6}, null);
        return this.parceAns(ans, 10);
    }

    public String getAccessorApplicationPartNumber() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 7}, null);
        return this.parceAns(ans, 10);
    }

    public String getAccessorApplicationId() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 14}, null);
        return this.parceAns(ans, 10);
    }

    public String getAccessorVariant() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 8}, null);
        return this.parceAns(ans, 33);
    }

    public String getAccessorVariantId() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 15}, null);
        return this.parceAns(ans, 10);
    }

    public Note getNoteDescription(int id) throws IOException {
        if (id < 1 || id > 50) {
            throw new IllegalArgumentException("id must be in 1..255");
        }
        byte[] res = this.sendExtendedMessage(2, new byte[]{(byte)id}).getExtendedData();
        return this.createNote(res);
    }

    public void reset() throws IOException {
        this.conn.sendReset();
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.params;
    }

    private EbdsStatus sendOmnibusMessage() throws IOException {
        byte[] res = this.conn.sendCommand(16, this.data, null);
        return this.parceAnswer(res);
    }

    private EbdsStatus sendExtendedMessage(int subType, byte[] extendedData) throws IOException {
        byte[] request = new byte[4 + extendedData.length];
        request[0] = (byte)subType;
        System.arraycopy(this.data, 0, request, 1, this.data.length);
        System.arraycopy(extendedData, 0, request, 4, extendedData.length);
        byte[] res = this.conn.sendCommand(112, request, null);
        return this.parceAnswer(res);
    }

    private EbdsStatus parceAnswer(byte[] res) {
        if ((res[0] & 0xF0) == 32) {
            return new EbdsStatus(res, null);
        }
        if ((res[0] & 0xF0) == 80) {
            return new EbdsStatus(new byte[]{0, 0, 0, 0, 2, 0, 0}, new byte[]{res[1], res[2], res[3], res[4]});
        }
        byte[] resData = new byte[7];
        resData[0] = res[0];
        System.arraycopy(res, 2, resData, 1, resData.length - 1);
        byte[] resDataExt = new byte[res.length - 8];
        System.arraycopy(res, 8, resDataExt, 0, resDataExt.length);
        return new EbdsStatus(resData, resDataExt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams sp : this.params) {
                try {
                    this.port.putParams(sp);
                    this.port.open();
                    this.conn.setAttempts(1);
                    this.conn.setAttemptsTimeout(500);
                    this.getAccessorType();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (IOException iOException) {
                }
                finally {
                    this.port.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.Ebds;
    }

    @Override
    public void open() throws IOException {
        this.port.open();
    }

    @Override
    public void close() {
        this.port.close();
    }

    public void debugData(byte[] data) {
        if (data == null || data.length != 7) {
            throw new IllegalArgumentException("\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043e\u0439 7 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
        }
        this.log.info((Object)(((data[1] & 1) != 0 ? "*idl" : "-idl") + " " + ((data[1] & 2) != 0 ? "*acc" : "-acc") + " " + ((data[1] & 4) != 0 ? "*esc" : "-esc") + " " + ((data[1] & 8) != 0 ? "*stg" : "-stg") + " " + ((data[1] & 0x10) != 0 ? "*std" : "-std") + " " + ((data[1] & 0x20) != 0 ? "*rtg" : "-rtg") + " " + ((data[1] & 0x40) != 0 ? "*rtd" : "-rtd") + "|" + ((data[2] & 1) != 0 ? "*che" : "-che") + " " + ((data[2] & 2) != 0 ? "*rej" : "-rej") + " " + ((data[2] & 4) != 0 ? "*jam" : "-jam") + " " + ((data[2] & 8) != 0 ? "*ful" : "-ful") + " " + ((data[2] & 0x10) != 0 ? "*att" : "-att") + " " + ((data[2] & 0x20) != 0 ? "*psd" : "-psd") + " " + ((data[2] & 0x40) != 0 ? "*cal" : "-cal") + "|" + ((data[3] & 1) != 0 ? "*pow" : "-pow") + " " + ((data[3] & 2) != 0 ? "*inv" : "-inv") + " " + ((data[3] & 4) != 0 ? "*fal" : "-fal") + "| hex=" + BU.toString((byte[])data)));
    }

    private String parceAns(byte[] ans, int len) {
        if (ans.length == len) {
            String res = "";
            for (int i = 1; i < ans.length; ++i) {
                char symbol = (char)ans[i];
                if (!Character.isLetterOrDigit(symbol)) continue;
                res = res + symbol;
            }
            return res;
        }
        return null;
    }

    @Override
    public void test() throws IOException {
        this.reset();
    }

    public Note createNote(byte[] data) {
        if (data[2] == 0 || data.length < 10) {
            return null;
        }
        try {
            Note n = new Note();
            n.setIndex(data[0]);
            n.setIsoCode(new String(data, 1, 3));
            n.setBase(Integer.parseInt(new String(data, 4, 3)));
            n.setExponent(Integer.parseInt(new String(data, 7, 3).replace("+", "")));
            return n;
        }
        catch (Exception ex) {
            this.log.error((Object)("Error on parce note description: " + ByteUtils.toString(data)), (Throwable)ex);
            return null;
        }
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        return new ValidatorInfo(this.getAccessorBootPartNumner());
    }

    public int queryDeviceResets() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 2}, null);
        this.log.info((Object)("counts=" + BU.toString((byte[])ans)));
        return ((ans[1] & 0xF) << 20) + ((ans[2] & 0xF) << 16) + ((ans[3] & 0xF) << 12) + ((ans[4] & 0xF) << 8) + ((ans[5] & 0xF) << 4) + (ans[6] & 0xF);
    }

    public int getFirmwareCRC() throws IOException {
        byte[] reply = this.conn.sendCommand(96, new byte[]{0, 0, 0}, null);
        if (reply == null) {
            throw new IOException("Accept null reply");
        }
        int crc = (reply[1] & 0xF) << 12 | (reply[2] & 0xF) << 8 | (reply[3] & 0xF) << 4 | reply[4] & 0xF;
        return crc;
    }

    public String getAccessorVariantPart() throws IOException {
        byte[] ans = this.conn.sendCommand(96, new byte[]{0, 0, 9}, null);
        return this.parceAns(ans, 10);
    }

    public boolean startDownloadFirmware() throws IOException {
        try {
            byte[] rez = this.conn.sendCommand(16, new byte[]{0, 0, 0}, null);
            if (rez != null && (rez[0] & 0xF0) == 80) {
                return true;
            }
        }
        catch (EbdsConnection.NAKException e) {
            byte[] rez = e.getReply();
            if (rez != null && (rez[0] & 0xF0) == 80) {
                return true;
            }
            throw e;
        }
        this.log.info((Object)"Get the device out of normal operation mode and into downloading mode");
        EbdsStatus status = new EbdsStatus(this.conn.sendCommand(80, new byte[]{0, 0, 16}, 1500), null);
        this.log.debug((Object)("Download mode: " + status.isFlashDownload()));
        return status.isFlashDownload();
    }

    public int blockDownloadFirmware(byte[] data, int blockNumber) throws IOException {
        byte[] blockData = new byte[data.length * 2 + 4];
        blockData[0] = (byte)(blockNumber >> 12 & 0xF);
        blockData[1] = (byte)(blockNumber >> 8 & 0xF);
        blockData[2] = (byte)(blockNumber >> 4 & 0xF);
        blockData[3] = (byte)(blockNumber & 0xF);
        for (int i = 0; i < data.length; ++i) {
            blockData[4 + 2 * i + 0] = (byte)(data[i] >> 4 & 0xF);
            blockData[4 + 2 * i + 1] = (byte)(data[i] & 0xF);
        }
        try {
            this.conn.sendCommand(80, blockData, 1500, 1);
            return blockNumber + 1;
        }
        catch (EbdsConnection.NAKException e) {
            byte[] reply = e.getReply();
            int retryBlockNumber = ((reply[1] & 0xF) << 12) + ((reply[2] & 0xF) << 8) + ((reply[3] & 0xF) << 4) + ((reply[4] & 0xF) + 1) & 0xFFFF;
            int ret = -retryBlockNumber - 1;
            return ret != -65534 ? ret : -1;
        }
    }

    public int fastBlockDownloadFirmware(byte[] data, int blockNumber) throws IOException {
        byte[] blockData = new byte[data.length + 2];
        blockData[1] = (byte)(blockNumber >> 8 & 0xFF);
        blockData[0] = (byte)(blockNumber & 0xFF);
        System.arraycopy(data, 0, blockData, 2, data.length);
        try {
            this.conn.sendCommand(80, blockData, 900, 1);
            return blockNumber + 1;
        }
        catch (EbdsConnection.NAKException reply) {
            int retryBlockNumber = 0;
            retryBlockNumber += reply.getReply()[2] & 0xFF;
            retryBlockNumber <<= 8;
            this.conn.reverseFlag();
            int ret = -(retryBlockNumber += reply.getReply()[1] & 0xFF) - 1;
            return ret != -65534 ? ret : -1;
        }
    }

    public boolean finishDownloadFirmware() throws IOException {
        byte[] res = this.conn.sendCommand(16, new byte[]{0, 0, 0}, 1500);
        return res != null && (res[0] & 0xF0) == 32;
    }

    public SerialParams setMaxBaudRate() {
        byte speednum = 0;
        try {
            try {
                speednum = this.conn.sendCommand(80, new byte[]{4}, null)[1];
            }
            catch (EbdsConnection.NAKException reply) {
                speednum = this.conn.sendCommand(80, new byte[]{reply.getReply()[1]}, null)[1];
            }
        }
        catch (IOException ex) {
            return null;
        }
        int[] speeds = new int[]{9600, 19200, 38400, 115200};
        return new SerialParams(speeds[speednum - 1], DataBits.Eight, StopBits.One, Parity.None);
    }
}

