/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ebds;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.cashin.validator.ebds.EbdsApi;

public abstract class BlockSearcher {
    protected EbdsApi api;
    protected int blockLength;
    protected RandomAccessFile raf;
    protected int blockCount;
    protected final Logger log;

    public BlockSearcher(EbdsApi api, Logger log) {
        this.api = api;
        this.log = log;
    }

    public void setFile(RandomAccessFile file) throws IOException {
        this.raf = file;
        this.blockCount = (int)(this.raf.length() / (long)this.blockLength);
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public byte[] getBlock(int blockNumber) throws IOException {
        byte[] data = new byte[this.blockLength];
        this.raf.seek((long)blockNumber * (long)this.blockLength);
        this.raf.read(data, 0, this.blockLength);
        return data;
    }

    protected abstract int downloadData(byte[] var1, int var2) throws IOException;

    public int downloadBlock(int blockNumber) throws IOException {
        byte[] data = this.getBlock(blockNumber);
        return this.downloadData(data, blockNumber);
    }
}

