/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ccnet;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.cashin.validator.ccnet.CcnetApi;
import ru.softlogic.hardware.device.cashin.validator.ccnet.CcnetInfo;
import ru.softlogic.hardware.device.cashin.validator.ccnet.UpdateBlock;
import ru.softlogic.hardware.device.cashin.validator.ccnet.UpdateParser;
import ru.softlogic.hdw.UpdateFailureException;
import ru.softlogic.io.utils.BU;
import ru.softlogic.system.util.PathUtils;

class Updater {
    public static final String FWFOLDER = "ccnet";
    private static final String SM_MODEL = "sm";
    private static final String SSF_FW = ".ssf";
    private static final String SSF_VERSION = "_ssf.version";
    private final CcnetApi api;
    private final Logger log;

    public Updater(CcnetApi api, Logger log) {
        this.api = api;
        this.log = log;
    }

    public boolean isSupportFwUpdate(CcnetInfo ci) {
        return ci != null && "SME".equals(ci.getModel());
    }

    public void checkFirmwareUpdate(DeviceInfo deviceInfo) throws IOException {
        CcnetInfo ci = this.api.identification();
        if (this.isSupportFwUpdate(ci)) {
            this.log.info((Object)"Search newest firmwares");
            try {
                File path = new File(PathUtils.getFirmwaresPath(), FWFOLDER);
                if (path.exists()) {
                    String devVersion = ci.getPartNumber().trim();
                    this.log.info((Object)"");
                    File vFile = new File(path, devVersion.substring(0, 2).toLowerCase() + SSF_VERSION);
                    if (vFile.canRead()) {
                        String vContent = FileUtils.readFileToString((File)vFile, (Charset)Charset.defaultCharset()).trim();
                        this.log.info((Object)("Versions: device=" + devVersion + ", file=" + vContent));
                        deviceInfo.setHasUpdate(!vContent.equalsIgnoreCase(devVersion));
                        LinkedList<String> fws = new LinkedList<String>();
                        fws.add(vContent);
                        deviceInfo.setUpdateInfo(((Object)fws).toString());
                    }
                }
            }
            catch (IOException ex) {
                this.log.error((Object)"Error on search newest firmwares", (Throwable)ex);
            }
        }
    }

    public void onlyLoad() throws IOException, InterruptedException, UpdateFailureException {
        File path = new File(PathUtils.getFirmwaresPath(), FWFOLDER);
        if (!path.exists()) {
            throw new UpdateFailureException("Update directory not found: " + path.getAbsolutePath());
        }
        try {
            int us = this.api.getUpdateStatus();
            this.log.info((Object)("Update status: " + BU.toHex((int)us)));
            if (!this.api.updateStart()) {
                throw new UpdateFailureException("Updating mode not activated");
            }
            this.log.info((Object)"Updating mode activated");
            Thread.sleep(1000L);
            int blockSize = 2 << this.api.getBlockSize() - 1;
            this.log.info((Object)("Block size: " + blockSize));
            if (blockSize != 256) {
                throw new UpdateFailureException("Unknown type of card with block size: " + blockSize);
            }
            this.log.info((Object)"Type of card: ssc");
            File fileSource = new File(path, "sm.ssf");
            if (!fileSource.exists()) {
                throw new UpdateFailureException("Source file not found: " + fileSource.getAbsolutePath());
            }
            List<UpdateBlock> blocks = UpdateParser.parse(fileSource, blockSize);
            int curentBlock = 0;
            Thread.sleep(1000L);
            this.log.info((Object)"Write updating...");
            block5: for (UpdateBlock data : blocks) {
                for (int i = 0; i < 5; ++i) {
                    int response = this.api.writeUpdating(data.buildRequest());
                    if (response == 224) {
                        this.log.info((Object)("Responce for block " + curentBlock + "/" + blocks.size() + ", attempt" + (i + 1) + ": ok"));
                        ++curentBlock;
                        continue block5;
                    }
                    this.log.info((Object)("Responce for block " + curentBlock + "/" + blocks.size() + ", attempt" + (i + 1) + ": error"));
                    if (i >= 4) {
                        throw new UpdateFailureException("Error writet updating to memory");
                    }
                    Thread.sleep(500L);
                }
            }
            Thread.sleep(1000L);
            if (this.api.updateEnd() != 224) {
                throw new UpdateFailureException("Stop updating mode error");
            }
            this.log.info((Object)"Stop updating mode: ok");
            this.log.info((Object)"Expect the device 15 seconds");
            Thread.sleep(15000L);
            this.log.info((Object)"Restarting device");
            this.api.reset();
        }
        catch (UpdateFailureException ex) {
            this.log.error((Object)"Erron on update", (Throwable)ex);
            this.api.updateEnd();
            throw ex;
        }
        finally {
            Thread.sleep(500L);
            this.api.reset();
        }
    }

    public void update() throws IOException, InterruptedException, UpdateFailureException {
        CcnetInfo ci = this.api.identification();
        this.log.info((Object)("Model info: " + ci));
        if (!this.isSupportFwUpdate(ci)) {
            throw new UpdateFailureException("Device is not support firmware update");
        }
        String version = FileUtils.readFileToString((File)new File(new File(PathUtils.getFirmwaresPath(), FWFOLDER), "sm_ssf.version"), (Charset)Charset.defaultCharset()).trim();
        if (version.endsWith(ci.getPartNumber().trim())) {
            this.log.info((Object)"Device has some firmware, update is not required");
            return;
        }
        this.log.info((Object)("Try to update firmware from=" + ci.getFirmware() + " to=" + version));
        this.onlyLoad();
    }
}

