/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ccnet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import ru.softlogic.hardware.device.cashin.validator.ccnet.UpdateBlock;
import ru.softlogic.hdw.UpdateFailureException;

class UpdateParser {
    private UpdateParser() {
    }

    public static List<UpdateBlock> parse(File source, int blocksize) throws UpdateFailureException {
        LinkedList<UpdateBlock> linkedList;
        LinkedHashMap adressBlocks = new LinkedHashMap();
        boolean endFlag = false;
        int currenthAdr = 0;
        LinkedList<String> strings = new LinkedList<String>();
        LinkedList<UpdateBlock> result = new LinkedList<UpdateBlock>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(source));
            while ((line = br.readLine()) != null) {
                String current = line.replace(" ", "");
                if (current.matches("^:02000004[0-9a-fA-F]{6}")) {
                    if (!strings.isEmpty()) {
                        if (adressBlocks.containsKey(currenthAdr)) {
                            ((List)adressBlocks.get(currenthAdr)).addAll(strings);
                        } else {
                            adressBlocks.put(currenthAdr, strings);
                        }
                        strings = new LinkedList();
                    }
                    currenthAdr = Integer.parseInt(current.substring(9, 13), 16);
                    continue;
                }
                if (current.matches("^:10.*")) {
                    strings.add(current);
                    continue;
                }
                if (!current.matches("^:00000001FF")) continue;
                endFlag = true;
                adressBlocks.put(currenthAdr, strings);
            }
            if (!endFlag) {
                throw new UpdateFailureException("Ending of code not founded");
            }
            for (Map.Entry b : adressBlocks.entrySet()) {
                for (int i = 0; i < 16 * ((List)b.getValue()).size() / blocksize; ++i) {
                    UpdateBlock curb = new UpdateBlock();
                    curb.setLen(blocksize);
                    curb.sethAdr((Integer)b.getKey());
                    curb.setlAdr(Integer.parseInt(((String)((List)b.getValue()).get(i * (blocksize / 16))).substring(3, 7), 16));
                    for (int j = 0; j < blocksize / 16; ++j) {
                        curb.addData(((String)((List)b.getValue()).get(i * (blocksize / 16) + j)).substring(9, 41));
                    }
                    result.add(curb);
                }
            }
            linkedList = result;
        }
        catch (IOException ex) {
            try {
                throw new UpdateFailureException((Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)br);
        return linkedList;
    }
}

