/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ccnet;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.hardware.device.cashin.validator.ccnet.BillType;
import ru.softlogic.hardware.device.cashin.validator.ccnet.CcnetConnection;
import ru.softlogic.hardware.device.cashin.validator.ccnet.CcnetInfo;
import ru.softlogic.hardware.device.cashin.validator.ccnet.CcnetStatus;
import ru.softlogic.hardware.device.cashin.validator.ccnet.WrongCommandException;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;
import ru.softlogic.system.util.ArrayUtils;

public class CcnetApi
implements ValidatorApi {
    private Map<Boolean, SerialParams[]> serialParams;
    private SerialPort port;
    private CcnetConnection conn;

    public CcnetApi(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("Needs SerialPort");
        }
        this.port = serialPort;
        this.conn = new CcnetConnection(serialPort);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None)});
    }

    @Override
    public final SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DeviceType look(boolean preferred) throws NoSuchDeviceException {
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.port.putParams(params);
                this.conn.setAttempts(1);
                this.conn.setAttemptsTimeout(500);
                this.conn.setIoTimeout(750);
                this.conn.open();
                this.reset();
                DeviceType deviceType = null;
                return deviceType;
            }
            catch (Exception exception) {
            }
            finally {
                this.conn.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public final DeviceType getDeviceType() {
        return DeviceType.Ccnet;
    }

    @Override
    public final void open() throws IOException {
        if (this.getAvailableParameters().length == 1) {
            this.port.putParams(this.getAvailableParameters()[0]);
        }
        this.conn.open();
    }

    @Override
    public final void close() {
        this.conn.close();
    }

    public final void reset() throws IOException {
        this.conn.sendCommand((byte)48);
    }

    public final BillType[] billTable() throws IOException {
        byte[] data = this.conn.sendCommand((byte)65);
        if (data.length != 120) {
            throw new IOException("Data size must have 120 byte length");
        }
        LinkedList<BillType> table = new LinkedList<BillType>();
        for (int i = 0; i < 24; ++i) {
            int nominal = data[i * 5] * (int)Math.pow(10.0, data[i * 5 + 4]);
            if (nominal <= 0) continue;
            String currency = "" + (char)data[i * 5 + 1] + (char)data[i * 5 + 2] + (char)data[i * 5 + 3];
            table.add(new BillType(i, currency, nominal));
        }
        return table.toArray(new BillType[table.size()]);
    }

    public final CcnetStatus poll() throws IOException {
        byte[] data = this.conn.sendCommand((byte)51);
        CcnetStatus result = new CcnetStatus();
        if (data.length >= 1) {
            result.setStatus(data[0] & 0xFF);
        }
        if (data.length >= 2) {
            result.setSubStatus(data[1] & 0xFF);
        }
        return result;
    }

    public final void enable() throws IOException {
        byte mask = -1;
        byte[] data = new byte[]{mask, mask, mask, mask, mask, mask};
        this.conn.sendCommand((byte)52, data);
    }

    public final void disable() throws IOException {
        byte mask = 0;
        byte[] data = new byte[]{mask, mask, mask, mask, mask, mask};
        this.conn.sendCommand((byte)52, data);
    }

    public final void stackCash() throws IOException {
        this.conn.sendCommand((byte)53);
    }

    public final void returnCash() throws IOException {
        this.conn.sendCommand((byte)54);
    }

    public final CcnetInfo identification() throws IOException {
        String firmware;
        String model;
        byte[] data = this.conn.sendCommand((byte)55);
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (int i = 0; i < data.length - 7; ++i) {
            char symbol = (char)data[i];
            if (i < 15) {
                sb1.append(BU.isStringChar((char)symbol) ? symbol : (char)' ');
                continue;
            }
            sb2.append(BU.isStringChar((char)symbol) ? symbol : (char)' ');
        }
        String pn = sb1.toString().trim();
        if (pn.contains("-")) {
            int pos = pn.indexOf(45);
            model = pn.substring(0, pos);
            firmware = pn.substring(pos + 1);
        } else {
            model = firmware = pn;
        }
        return new CcnetInfo(model, firmware, pn, sb2.toString().trim());
    }

    @Override
    public void test() throws IOException {
        this.reset();
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        CcnetInfo info = this.identification();
        return new ValidatorInfo(info.getPartNumber());
    }

    public boolean updateStart() throws IOException {
        byte[] data = this.conn.sendCommand((byte)80, null, false);
        return data != null && data[0] == 0;
    }

    public int getUpdateStatus() throws IOException {
        byte[] data = this.conn.sendCommand((byte)80, new byte[]{0}, false);
        return data[0];
    }

    public byte getBlockSize() throws IOException {
        byte[] data = this.conn.sendCommand((byte)80, new byte[]{1}, false);
        return data[0];
    }

    public int writeUpdating(byte[] block) throws IOException {
        byte[] respose = this.conn.sendCommand((byte)80, block, false);
        return respose[0] & 0xFF;
    }

    public int updateEnd() throws IOException {
        byte[] data = this.conn.sendCommand((byte)80, new byte[]{3}, false);
        return data[0] & 0xFF;
    }

    public boolean isDownloadMode() throws IOException {
        try {
            this.conn.sendCommandEx((byte)49, null, true);
            return false;
        }
        catch (WrongCommandException ex) {
            return this.getBlockSize() != 0;
        }
    }
}

