/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator;

import java.util.Map;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.cashin.validator.BillTable;
import ru.softlogic.hardware.device.cashin.validator.Denomination;

public class DynamicBillTable
implements BillTable {
    private Map<Integer, Denomination> map;
    private final CashFactory cf;

    public DynamicBillTable(String currency) {
        this.cf = CashFactory.getInstance((String)currency);
    }

    @Override
    public void setTable(Map<Integer, Denomination> map) {
        if (map == null) {
            throw new NullPointerException("Map is null");
        }
        this.map = map;
    }

    @Override
    public CashUnit get(int id) {
        if (this.map == null) {
            return null;
        }
        Denomination den = this.map.get(id);
        if (den == null) {
            return null;
        }
        return this.cf.getCashUnitByNominal(new Sum(den.getValue() * 100));
    }
}

