/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.nriC2;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class NRIConnection {
    private SerialPort port;
    private Logger log;
    public static final byte[] ACK = new byte[]{1, 0};
    public static final byte OK = 46;
    public static final byte NAK = 88;
    private static final int sendAttempts = 1;
    private static final int attemptsTimeout = 1000;

    public NRIConnection(SerialPort port, Logger log) {
        if (port == null) {
            throw new IllegalArgumentException("Port must be not null");
        }
        if (log == null) {
            throw new IllegalArgumentException("Logger must be not null");
        }
        this.port = port;
        this.log = log;
    }

    public void open() throws IOException {
        this.port.open();
    }

    public void close() {
        this.port.close();
    }

    public byte sendModeCmd(int param) throws IOException {
        return this.sendCmd(BU.c((int)133), new byte[]{BU.c((int)param)}, true)[0];
    }

    public byte[] sendDataCmd(int ... params) throws IOException {
        byte[] p = new byte[params.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = BU.c((int)params[i]);
        }
        return this.sendCmd(BU.c((int)136), p, true);
    }

    private byte[] sendCmd(byte cmd, byte[] data, boolean readAnsw) throws IOException {
        byte[] sendcmd = new byte[data.length + 2];
        sendcmd[0] = BU.c((int)(data.length + 1));
        sendcmd[1] = cmd;
        for (int i = 2; i < data.length + 2; ++i) {
            sendcmd[i] = data[i - 2];
        }
        return this.sendData(sendcmd, readAnsw);
    }

    private synchronized byte[] sendData(byte[] data, boolean readAnsw) throws IOException {
        IOException lastException = null;
        for (int i = 0; i < 1; ++i) {
            try {
                this.port.flush(Flush.RxTx);
                this.log.debug((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u2116" + i));
                this.log.debug((Object)("\u041f\u0438\u0448\u0435\u043c \u0432 \u043f\u043e\u0440\u0442 " + BU.toString((byte[])data)));
                this.port.write(data);
                if (readAnsw) {
                    this.log.debug((Object)"\u0427\u0438\u0442\u0430\u0435\u043c \u043e\u0442\u0432\u0435\u0442");
                    byte[] result = this.port.read();
                    this.log.debug((Object)("\u041e\u0442\u0432\u0435\u0442 " + BU.toString((byte[])result)));
                    return result;
                }
                return null;
            }
            catch (IOException e) {
                lastException = e;
                this.log.error((Object)e, (Throwable)e);
                continue;
            }
        }
        this.log.error((Object)lastException, (Throwable)lastException);
        throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0441\u043b\u0430\u0442\u044c \u043f\u0430\u043a\u0435\u0442!" + this.port + "  !", lastException);
    }
}

