/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.nriC2;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.MoneyUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.coin.nriC2.Activity;
import ru.softlogic.hardware.device.cashin.coin.nriC2.CurenzaApi;
import ru.softlogic.hardware.device.cashin.coin.nriC2.DiagnosticStatus;
import ru.softlogic.hardware.device.cashin.coin.nriC2.Info;
import ru.softlogic.hardware.device.cashin.coin.nriC2.Status;
import ru.softlogic.hardware.device.cashin.coin.nriC2.TubeStatus;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.hopper.DispenseListener;
import ru.softlogic.hardware.device.hopper.HopperException;
import ru.softlogic.hardware.device.hopper.IHopper;
import ru.softlogic.hardware.device.hopper.PayoutOperation;
import ru.softlogic.hardware.device.hopper.algorithm.Denomination;
import ru.softlogic.hardware.device.hopper.algorithm.GreedyAlgorithmCalculator;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class Driver
extends Validator
implements IHopper {
    private static final long SLEEP_TIME = 500L;
    private static final long DIAGNOSTIC_INTERVAL = 5000L;
    private static final int COUNT_POLL_AFTER_DISPENSE = 25;
    private static final int COUNT_POLL_AFTER_RESET = 10;
    private final SerialPort port;
    private final CurenzaApi api;
    private final DeviceInfo info;
    private final Map<Integer, CashUnit> billTable;
    private final Map<Integer, Integer> billTableMap;
    private final CashFactory cf;
    private final AtomicReference<PayoutOperation> payoutOperation;
    private final GreedyAlgorithmCalculator pc;
    private Keeper payoutKeeper;
    private long lastDiagnostic;
    private final LinkedList<Activity> activities = new LinkedList();

    public Driver(SerialPort port, String currency) {
        super("coin");
        this.port = port;
        this.info = new DeviceInfo(DeviceType.CurrenzaC2);
        this.info.setPort(port.getName());
        this.api = new CurenzaApi(port, this.log);
        this.billTable = new HashMap<Integer, CashUnit>();
        this.billTableMap = new HashMap<Integer, Integer>();
        this.cf = CashFactory.getInstance((String)currency);
        this.pc = new GreedyAlgorithmCalculator(20);
        this.payoutOperation = new AtomicReference();
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.log.info((Object)"Start thread");
            this.log.info((Object)("Device type: " + (Object)((Object)DeviceType.CurrenzaC2)));
            this.log.info((Object)("Serial params: " + this.port.getParams()));
            boolean inited = false;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    List<Activity> polledActivities;
                    if (!inited) {
                        this.enable();
                        inited = true;
                        this.notifyStatus(ValidatorStatus.Init);
                    }
                    if ((polledActivities = this.api.poll()) != null) {
                        this.activities.addAll(polledActivities);
                    }
                    if (!this.activities.isEmpty()) {
                        this.processPoll(this.activities.removeFirst());
                    }
                    this.processPayout();
                    this.processDiagnostic();
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    this.log.info((Object)"I/O error", (Throwable)ex);
                    inited = false;
                    this.api.close();
                    PayoutOperation po = this.payoutOperation.getAndSet(null);
                    if (po != null) {
                        if (this.payoutKeeper != null && !this.payoutKeeper.getSum().isEmpty()) {
                            po.getListener().onResult(this.payoutKeeper);
                        } else {
                            po.getListener().onError();
                        }
                        this.payoutKeeper = null;
                    }
                    ThreadUtil.sleep((long)1000L);
                    this.notifyStatus(ValidatorStatus.ConnectionError);
                }
            }
            this.log.info((Object)"Disable coin acceptor");
        }
        finally {
            try {
                this.enable = false;
                this.api.disable();
                this.api.close();
            }
            catch (IOException ex) {
                this.log.error((Object)"Error on set disable", (Throwable)ex);
            }
            this.log.info((Object)"Stop thread");
        }
    }

    private void enable() throws IOException {
        try {
            this.log.info((Object)("Try to open device on port: " + this.port.getName()));
            this.api.open();
            for (int i = 3; i >= 0 && !this.api.mdbInit(); --i) {
                if (i != 0) continue;
                throw new IOException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            }
            this.log.info((Object)"Try to reset device");
            this.api.reset();
            int attempts = 10;
            this.log.info((Object)"Wait reset activity");
            while (attempts-- > 0) {
                ThreadUtil.sleep((long)500L);
                List<Activity> polledActivities = this.api.poll();
                if (polledActivities == null) continue;
                this.activities.addAll(polledActivities);
                if (polledActivities.contains(Activity.CHANGER_WAS_RESET_ACTIVITY)) continue;
            }
            if (attempts <= 0) {
                this.log.error((Object)"No reset status polled after 10 attempts");
                throw new IOException("Coin acceptor not reset after 10 poll");
            }
            this.log.info((Object)"Reset status polled");
            this.log.info((Object)"Enable device");
            this.api.enable();
            Info nriInfo = this.api.info();
            this.info.setPort(this.port.getName());
            if (nriInfo != null) {
                this.info.setVendor(nriInfo.getCompany());
                this.info.setModel(nriInfo.getModel());
                this.info.setSerial(nriInfo.getSerial());
                this.info.setFirmware(nriInfo.getSoftware());
            }
            this.log.info((Object)"Get coin description:");
            this.billTable.clear();
            this.billTableMap.clear();
            ThreadUtil.sleep((long)300L);
            Status status = this.api.setup();
            this.log.info((Object)("Coin acceptor status: " + status));
            for (int i = 0; i < 16; ++i) {
                Sum s = new Sum(1.0 * (double)status.getCoinTypeCredit(i) / (double)status.getCoinScalingFactor());
                this.billTable.put(i, this.cf.getCoinUnitByNominal(s));
                this.billTableMap.put(s.getBasicSum(), i);
            }
            this.log.info((Object)("Coin table: " + this.billTable));
        }
        catch (IOException ex) {
            this.log.error((Object)"I/O error", (Throwable)ex);
            throw ex;
        }
    }

    private void processPoll(Activity activity) throws IOException {
        if (activity == null) {
            return;
        }
        switch (activity.getActivityType()) {
            case 64: {
                this.processCoinDeposited(activity);
                return;
            }
            case 128: {
                this.log.info((Object)("Number of coins dispensed: " + activity.getNumberOfCoinsDispenced()));
                return;
            }
            case 32: {
                this.log.info((Object)("Number of slugs since the last activity: " + activity.getNumberOfSlugs()));
                return;
            }
        }
        switch (activity.getStatus()) {
            case 1: {
                this.log.info((Object)"Escrow request");
                this.notifyStatus(ValidatorStatus.Ok);
                break;
            }
            case 2: {
                this.log.debug((Object)"Changer Payout Busy");
                break;
            }
            case 3: {
                this.log.info((Object)"No Credit");
                break;
            }
            case 4: {
                this.log.info((Object)"Defective Tube Sensor");
                break;
            }
            case 5: {
                this.log.info((Object)"Double Arrival");
                this.notifyEvent(Event.CommonReject);
                break;
            }
            case 6: {
                this.log.info((Object)"Acceptor Unplugged");
                this.notifyStatus(ValidatorStatus.StackOut);
                break;
            }
            case 7: {
                this.log.info((Object)"Tube Jam");
                this.notifyStatus(ValidatorStatus.JammInStack);
                break;
            }
            case 8: {
                this.log.info((Object)"ROM Checksum Error");
                this.notifyStatus(ValidatorStatus.ConnectionError);
                break;
            }
            case 9: {
                this.log.info((Object)"Coin Routing Error");
                break;
            }
            case 10: {
                this.log.debug((Object)"Changer Busy");
                break;
            }
            case 11: {
                this.log.info((Object)"Changer was Reset");
                break;
            }
            case 12: {
                this.log.info((Object)"Coin Jam");
                this.notifyStatus(ValidatorStatus.JammInStack);
                break;
            }
            case 13: {
                this.log.info((Object)"Possible Credited Coin Removal");
                break;
            }
            default: {
                this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435: " + activity.getStatus()));
            }
        }
    }

    private void processCoinDeposited(Activity activity) throws IOException {
        if (activity.getActivityType() != 64) {
            return;
        }
        if (activity.getCoinRouting() != 0 && activity.getCoinRouting() != 1) {
            this.notifyEvent(Event.CommonReject);
            return;
        }
        if (this.cashStorage == null) {
            this.log.info((Object)"Cash storage is null. Return coin");
            this.api.dispense(activity);
            this.notifyEvent(Event.CommonReject);
            return;
        }
        CashUnit coin = this.billTable.get(activity.getCoinType());
        if (coin == null || !this.cashStorage.cashPermit(coin)) {
            this.log.info((Object)"Coin not permitted. Return coin");
            this.api.dispense(activity);
            this.notifyEvent(Event.CommonReject);
            return;
        }
        this.log.info((Object)("Coin accepted: " + coin));
        this.cashStorage.addCash(coin);
        this.notifyCash(coin);
    }

    private void processPayout() throws IOException {
        PayoutOperation po = this.payoutOperation.get();
        if (po == null) {
            return;
        }
        this.log.info((Object)("Begin payout: " + po));
        HashMap<Denomination, Integer> presence = new HashMap<Denomination, Integer>();
        TubeStatus status = this.api.tubeStatus();
        this.log.info((Object)("Tube status: " + status));
        for (int i = 0; i < 16; ++i) {
            CashUnit cu = this.billTable.get(i);
            if (cu == null) continue;
            presence.put(new Denomination(1, cu.getNominal().getBasicSum()), status.getCoinCount(i));
        }
        this.log.info((Object)("Presence: " + presence));
        Map<Denomination, Integer> payoutSet = this.pc.calculate(presence, po.getSumPayout());
        this.log.info((Object)("Payout set: " + payoutSet));
        this.payoutKeeper = new Keeper();
        for (Map.Entry<Denomination, Integer> e : payoutSet.entrySet()) {
            Integer idx = this.billTableMap.get(e.getKey().getNominal());
            if (idx != null) {
                int i = 0;
                while (i < e.getValue()) {
                    ThreadUtil.sleep((long)500L);
                    int number = Math.min(15, e.getValue() - i);
                    this.log.info((Object)("Dispense " + number + " coin(s) of type " + idx));
                    this.api.dispense(idx, number);
                    i += number;
                    this.log.info((Object)"Wait while coin acceptor is busy");
                    int attempts = 25;
                    while (attempts-- > 0) {
                        ThreadUtil.sleep((long)500L);
                        List<Activity> polledActivities = null;
                        try {
                            polledActivities = this.api.poll();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (polledActivities == null) continue;
                        boolean isPayoutBusy = polledActivities.remove(Activity.CHANGER_PAYOUT_BUSY_ACTIVITY);
                        this.activities.addAll(polledActivities);
                        if (isPayoutBusy) continue;
                    }
                    if (attempts <= 0) {
                        this.log.error((Object)"Coin acceptor still busy after 25 poll");
                        throw new IOException("Coin acceptor still busy after 25 poll");
                    }
                    for (int k = 0; k < number; ++k) {
                        this.payoutKeeper.addCash(this.billTable.get(idx));
                    }
                    po.getListener().onProcess(this.payoutKeeper.getSum().getBasicSum());
                }
                continue;
            }
            this.log.error((Object)("Unknown idx for " + e.getKey()));
        }
        this.log.info((Object)("Dispensed " + this.payoutKeeper));
        po.getListener().onResult(this.payoutKeeper);
        this.payoutKeeper = null;
        this.payoutOperation.set(null);
    }

    private void processDiagnostic() throws IOException {
        if (System.currentTimeMillis() - this.lastDiagnostic > 5000L) {
            this.lastDiagnostic = System.currentTimeMillis();
            DiagnosticStatus status = this.api.diagnostic();
            if (status.getStatus() == 3) {
                this.notifyStatus(ValidatorStatus.Ok);
                return;
            }
            if (status.getStatus() == 3 && status.getSubStatus() == 2) {
                this.notifyStatus(ValidatorStatus.StackOut);
            }
        }
    }

    @Override
    public void clear(DispenseListener dl, int i, Keeper keeper) throws HopperException, IOException {
        this.log.info((Object)"\u0420\u0443\u0447\u043d\u043e\u0435 \u043e\u043f\u0443\u0441\u0442\u043e\u0448\u0435\u043d\u0438\u0435");
    }

    @Override
    public void add(MoneyUnit mu, int i) throws HopperException, IOException {
    }

    @Override
    public Keeper getKeeper() {
        return null;
    }

    @Override
    public void payout(PayoutOperation po) throws HopperException, IOException {
        if (po == null || po.getListener() == null) {
            return;
        }
        if (!this.payoutOperation.compareAndSet(null, po)) {
            this.log.error((Object)"Other payout operation in process");
            po.getListener().onError();
        }
    }

    @Override
    public void flowDownCoins(Keeper keeper, DispenseListener dl) throws HopperException, IOException {
    }

    @Override
    public boolean isFlowDownSupported() {
        return false;
    }
}

