/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.nriC2;

import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.cashin.coin.nriC2.NRIConnection;
import ru.softlogic.io.serial.SerialPort;

public class Connection {
    private final NRIConnection connection;

    public Connection(SerialPort port, Logger log) {
        this.connection = new NRIConnection(port, log);
    }

    public boolean init() throws IOException {
        return this.connection.sendModeCmd(10) == 46;
    }

    public byte[] reset() throws IOException {
        return this.connection.sendDataCmd(8);
    }

    public byte[] setup() throws IOException {
        return this.clear(this.connection.sendDataCmd(9));
    }

    public byte[] tubeStatus() throws IOException {
        return this.clear(this.connection.sendDataCmd(10));
    }

    public byte[] poll() throws IOException {
        return this.clear(this.connection.sendDataCmd(11));
    }

    public byte[] coinType(int[] mask) throws IOException {
        int[] send = new int[mask.length + 1];
        send[0] = 12;
        System.arraycopy(mask, 0, send, 1, mask.length);
        return this.connection.sendDataCmd(send);
    }

    public byte[] dispence(int param) throws IOException {
        return this.connection.sendDataCmd(13, param);
    }

    private byte[] expansion(int subCommand) throws IOException {
        return this.connection.sendDataCmd(15, subCommand);
    }

    public byte[] expansionIdentification() throws IOException {
        return this.clear(this.expansion(0));
    }

    public byte[] expansionDiagnistic() throws IOException {
        return this.clear(this.expansion(5));
    }

    public void open() throws IOException {
        this.connection.open();
    }

    public void close() {
        this.connection.close();
    }

    private byte[] clear(byte[] data) {
        if (data == null) {
            return null;
        }
        if (Arrays.equals(data, NRIConnection.ACK)) {
            return data;
        }
        int length = data.length;
        if (length <= 2 || length % 2 != 0 || data[length - 2] != 1) {
            return data;
        }
        for (int i = 0; i < length - 2; i += 2) {
            if (data[i] == 0) continue;
            return data;
        }
        byte[] cleared = new byte[length / 2 - 1];
        int i = 0;
        for (int j = 1; i < cleared.length && j < data.length; ++i, j += 2) {
            cleared[i] = data[j];
        }
        return cleared;
    }
}

