/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.nriC2;

public final class Activity {
    public static final int ACTIVITY_TYPE_COINT_DISPENSED_MANUALLY = 128;
    public static final int ACTIVITY_TYPE_COINT_DEPOSITED = 64;
    public static final int ACTIVITY_TYPE_SLUG = 32;
    public static final int ACTIVITY_TYPE_STATUS = 0;
    public static final int STATUS_ESCROW_REQUEST = 1;
    public static final int STATUS_CHANGER_PAYOUT_BUSY = 2;
    public static final int STATUS_NO_CREDIT = 3;
    public static final int STATUS_DEFECTIVE_TUBE_SENSOR = 4;
    public static final int STATUS_DEFECTIVE_DOUBLE_ARRIVAL = 5;
    public static final int STATUS_ACCEPTOR_UNPLUGGED = 6;
    public static final int STATUS_TUBE_JAM = 7;
    public static final int STATUS_ROM_CHECKSUM_ERROR = 8;
    public static final int STATUS_COINT_ROUTING_ERROR = 9;
    public static final int STATUS_CHANGER_BUSY = 10;
    public static final int STATUS_CHANGER_WAS_RESET = 11;
    public static final int STATUS_COIN_JAM = 12;
    public static final int STATUS_POSSIBLE_CREDITED_COIN_REMOVAL = 13;
    public static final int COIN_ROUTING_CASH_BOX = 0;
    public static final int COIN_ROUTING_TUBES = 1;
    public static final int COIN_ROUTING_NOT_USED = 2;
    public static final int COIN_ROUTING_REJECTED = 3;
    public static final Activity CHANGER_PAYOUT_BUSY_ACTIVITY = new Activity(2, 2);
    public static final Activity CHANGER_WAS_RESET_ACTIVITY = new Activity(11, 11);
    private final int activityType;
    private final int x;
    private final int y;
    private final int z;

    public Activity(int l, int r) {
        if ((l & 0x80) != 0) {
            this.activityType = 128;
            this.x = l & 0xF;
            this.y = (l & 0x70) >> 4;
            this.z = r;
        } else if ((l & 0x40) != 0) {
            this.activityType = 64;
            this.x = l & 0xF;
            this.y = (l & 0x30) >> 4;
            this.z = r;
        } else if ((l & 0x20) != 0) {
            this.activityType = 32;
            this.x = l & 0x1F;
            this.y = 0;
            this.z = 0;
        } else {
            this.activityType = 0;
            this.x = l;
            this.y = 0;
            this.z = 0;
        }
    }

    public int getActivityType() {
        return this.activityType;
    }

    public int getNumberOfCoinsDispenced() {
        return this.activityType == 128 ? this.y : -1;
    }

    public int getCoinType() {
        return this.activityType == 128 || this.activityType == 64 ? this.x : -1;
    }

    public int getNumberOfCoinsInTube() {
        return this.activityType == 128 || this.activityType == 64 ? this.z : -1;
    }

    public int getCoinRouting() {
        return this.activityType == 64 ? this.y : -1;
    }

    public int getStatus() {
        return this.activityType == 0 ? this.x : -1;
    }

    public int getNumberOfSlugs() {
        return this.activityType == 32 ? this.x : -1;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.activityType;
        hash = 97 * hash + this.x;
        hash = 97 * hash + this.y;
        hash = 97 * hash + this.z;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Activity other = (Activity)obj;
        if (this.activityType != other.activityType) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return "CoinAcceptorMDBStatus{activityType=" + this.activityType + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }
}

