/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.mei;

import java.io.IOException;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;
import ru.softlogic.system.util.ThreadUtil;

public class NRIConnection {
    private SerialPort port;
    private Logger log;
    public static final byte[] ACK = new byte[]{1, 0};
    public static final byte[] EMPTY_ANSWER = new byte[0];
    public static final byte OK = 46;
    public static final byte NAK = 88;
    private static final int sendAttempts = 3;
    private static final int attemptsTimeout = 1000;

    public NRIConnection(SerialPort port, Logger log) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043a\u043e\u043c-\u043f\u043e\u0440\u0442\u0435");
        }
        if (log == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043b\u043e\u0433\u0433\u0435\u0440\u0435");
        }
        this.port = port;
        port.setTimeout(3000);
        this.log = log;
    }

    public byte sendModeCmd(int param) throws IOException {
        return this.sendCmd(BU.c((int)133), new byte[]{BU.c((int)param)}, true)[0];
    }

    public byte[] sendCmd(int cmd) throws IOException {
        return this.sendCmd(cmd, null, true);
    }

    public byte[] sendCmd(int cmd, byte[] data, boolean readAnsw, int timeout) throws IOException {
        byte[] sendcmd = new byte[(data == null ? 0 : data.length) + 1];
        sendcmd[0] = BU.c((int)cmd);
        if (data != null) {
            System.arraycopy(data, 0, sendcmd, 1, data.length);
        }
        return this.sendData(sendcmd, readAnsw, timeout);
    }

    public byte[] sendCmd(int cmd, byte[] data, boolean readAnsw) throws IOException {
        return this.sendCmd(cmd, data, readAnsw, 300);
    }

    private byte[] sendData(byte[] data, boolean readAnsw, int timeout) throws IOException {
        IOException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.port.flush(Flush.RxTx);
                this.log.debug((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u2116" + i));
                this.log.debug((Object)("\u041f\u0438\u0448\u0435\u043c \u0432 \u043f\u043e\u0440\u0442 " + BU.toString((byte[])data)));
                this.port.write(data);
                if (readAnsw) {
                    ThreadUtil.sleep((long)timeout);
                    this.log.debug((Object)"\u0427\u0438\u0442\u0430\u0435\u043c \u043e\u0442\u0432\u0435\u0442");
                    if (this.port.avaliable() > 0) {
                        byte[] result = this.port.tryRead(500);
                        this.log.debug((Object)("\u041e\u0442\u0432\u0435\u0442 " + BU.toString((byte[])result)));
                        return result;
                    }
                }
                return EMPTY_ANSWER;
            }
            catch (IOException e) {
                lastException = e;
                this.log.error((Object)e, (Throwable)e);
                if (i >= 2) continue;
                try {
                    Random rnd = new Random();
                    int r = rnd.nextInt(1000);
                    Thread.sleep(r);
                    this.port.flush(Flush.RxTx);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        this.log.error((Object)lastException, (Throwable)lastException);
        throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0441\u043b\u0430\u0442\u044c \u043f\u0430\u043a\u0435\u0442!", lastException);
    }

    public byte[] readData() throws IOException {
        try {
            if (this.port.avaliable() > 0) {
                byte[] result = this.port.tryRead(500);
                this.log.debug((Object)("\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e " + BU.toString((byte[])result)));
                return result;
            }
        }
        catch (IOException e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return EMPTY_ANSWER;
    }
}

