/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.mei;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.MoneyUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.coin.mei.MDBInfo;
import ru.softlogic.hardware.device.cashin.coin.mei.MeiMDBApi;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.hopper.DispenseListener;
import ru.softlogic.hardware.device.hopper.HopperException;
import ru.softlogic.hardware.device.hopper.IHopper;
import ru.softlogic.hardware.device.hopper.PayoutOperation;
import ru.softlogic.hardware.device.hopper.algorithm.Denomination;
import ru.softlogic.hardware.device.hopper.algorithm.GreedyAlgorithmCalculator;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class Driver
extends Validator
implements IHopper {
    private final SerialPort port;
    private final MeiMDBApi api;
    private final DeviceInfo info;
    private final Map<Integer, CashUnit> billTable;
    private final Map<Integer, Integer> billTableMap;
    private final CashFactory cf;
    private volatile PayoutOperation payoutOperation;
    private final GreedyAlgorithmCalculator pc;
    private Keeper payoutKeeper;
    private long lastDiagnostic;

    public Driver(SerialPort port, String currency) {
        super("coin");
        this.port = port;
        this.info = new DeviceInfo(DeviceType.MeiCF7000);
        this.info.setPort(port.getName());
        this.api = new MeiMDBApi(port, this.log);
        this.billTable = new HashMap<Integer, CashUnit>();
        this.billTableMap = new HashMap<Integer, Integer>();
        this.cf = CashFactory.getInstance((String)currency);
        this.pc = new GreedyAlgorithmCalculator(20);
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.log.info((Object)("Device type: " + (Object)((Object)DeviceType.MeiCF7000)));
        this.log.info((Object)("Serial params: " + this.port.getParams()));
        boolean inited = false;
        Boolean lastEnable = null;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (!inited) {
                    this.getCoinInfo();
                    inited = true;
                    this.notifyStatus(ValidatorStatus.Init);
                }
                if (lastEnable == null || lastEnable != this.enable) {
                    lastEnable = this.enable;
                    if (this.enable) {
                        this.log.info((Object)"Enable coin acceptor, modify inhibit status");
                        this.processChannels();
                        this.log.info((Object)"Success");
                    } else {
                        this.log.info((Object)"Disable coin acceptor");
                        this.processChannels();
                        this.log.info((Object)"Process channels done");
                    }
                }
                this.processPayout();
                this.processPoll(this.api.readEvent());
                this.processDiagnostic();
                ThreadUtil.sleep((long)100L);
            }
            catch (Exception ex) {
                this.log.info((Object)"I/O error", (Throwable)ex);
                inited = false;
                this.api.close();
                PayoutOperation po = this.payoutOperation;
                if (po != null) {
                    if (this.payoutKeeper != null && !this.payoutKeeper.getSum().isEmpty()) {
                        this.payoutOperation.getListener().onResult(this.payoutKeeper);
                    } else {
                        this.payoutOperation.getListener().onError();
                    }
                    this.payoutOperation = null;
                    this.payoutKeeper = null;
                }
                ThreadUtil.sleep((long)1000L);
                this.notifyStatus(ValidatorStatus.ConnectionError);
            }
        }
        this.log.info((Object)"Disable coin acceptor");
        try {
            this.enable = false;
            this.processChannels();
        }
        catch (IOException ex) {
            this.log.error((Object)"Error on set disable", (Throwable)ex);
        }
        this.log.info((Object)"Stop thread");
    }

    private void getCoinInfo() throws IOException {
        try {
            this.log.info((Object)("Try to open port " + this.port.getName()));
            this.api.open();
            this.log.info((Object)"Disable channels");
            this.log.info((Object)("Reset result: " + new String(this.api.reset())));
            ThreadUtil.sleep((long)300L);
            byte[] mask = new byte[]{0, 0, 0, 0};
            this.log.info((Object)("Disable all nominals result: " + new String(this.api.billType(mask))));
            ThreadUtil.sleep((long)300L);
            MDBInfo meiInfo = this.api.info();
            this.info.setPort(this.port.getName());
            if (meiInfo != null) {
                this.info.setVendor(meiInfo.getCompany());
                this.info.setModel(meiInfo.getModel());
                this.info.setSerial(meiInfo.getSerial());
                this.info.setFirmware(meiInfo.getSoftware());
            }
            this.log.info((Object)"Get coin description:");
            this.billTable.clear();
            this.billTableMap.clear();
            ThreadUtil.sleep((long)300L);
            byte[] res = this.api.setup();
            if (res.length == 24) {
                for (int i = 0; i < 16; ++i) {
                    Sum s = new Sum(res[3] * res[i + 7]);
                    this.billTable.put(i, this.cf.getCoinUnitByNominal(s));
                    this.billTableMap.put(s.getBasicSum(), i);
                }
            }
            this.log.info((Object)("Coin table: " + this.billTable));
        }
        catch (IOException ex) {
            this.log.error((Object)"I/O error", (Throwable)ex);
            throw ex;
        }
    }

    private void processChannels() throws IOException {
        this.log.info((Object)"Modify channels");
        int res = 0;
        for (Integer i : this.billTable.keySet()) {
            CashUnit cu = this.billTable.get(i);
            if (this.canStack(cu)) {
                res |= 1 << i;
                this.log.info((Object)("Enable channel: " + i));
                continue;
            }
            this.log.info((Object)("Disable channel: " + i));
        }
        this.log.info((Object)("Result mask: " + res));
        this.api.billType(new byte[]{(byte)(res & 0xF0), (byte)(res & 0xF), 0, 0});
        this.log.info((Object)"Result mask done");
    }

    boolean canStack(CashUnit cu) {
        if (this.cashStorage != null && cu != null) {
            return this.cashStorage.cashPermit(cu);
        }
        return false;
    }

    private void processPoll(byte[] poll) {
        if (poll == null || poll.length < 2) {
            return;
        }
        this.log.debug((Object)("Pull<<" + ByteUtils.toString(poll)));
        if ((poll[1] & 0x40) != 0) {
            this.log.debug((Object)("Coin " + (poll[1] & 0xF)));
            CashUnit cu = this.billTable.get(poll[1] & 0xF);
            if (cu != null) {
                this.log.info((Object)("Get coin: " + cu));
                this.notifyCash(cu);
                this.cashStorage.addCash(cu);
            }
        }
    }

    private void processPayout() throws IOException {
        if (this.payoutOperation != null) {
            HashMap<Denomination, Integer> presence = new HashMap<Denomination, Integer>();
            byte[] st = this.api.status();
            this.log.info((Object)("Tube status: " + ByteUtils.toString(st)));
            if (st.length < 19) {
                ThreadUtil.sleep((long)1000L);
                st = this.api.status();
                this.log.info((Object)("Tube status: " + ByteUtils.toString(st)));
                if (st.length < 19) {
                    this.log.error((Object)"Incorrect tube status");
                    this.payoutOperation.getListener().onError();
                    this.payoutOperation = null;
                    return;
                }
            }
            for (int i = 0; i < 16; ++i) {
                CashUnit cu = this.billTable.get(i);
                if (cu == null) continue;
                presence.put(new Denomination(1, cu.getNominal().getBasicSum()), st[i + 2] & 0xFF);
            }
            this.log.info((Object)("Presence: " + presence));
            Map<Denomination, Integer> po = this.pc.calculate(presence, this.payoutOperation.getSumPayout());
            this.log.info((Object)("Payout set: " + po));
            this.payoutKeeper = new Keeper();
            for (Map.Entry<Denomination, Integer> e : po.entrySet()) {
                Integer idx = this.billTableMap.get(e.getKey().getNominal());
                if (idx != null) {
                    for (int i = 0; i < e.getValue(); ++i) {
                        ThreadUtil.sleep((long)300L);
                        this.api.dispense((byte)(0x10 | idx));
                        ThreadUtil.sleep((long)300L);
                        byte[] res = this.api.readEvent();
                        if (res == null || res.length <= 1 || res[0] != 8 || res[1] != 2) continue;
                        this.payoutKeeper.addCash(this.billTable.get(idx));
                        this.payoutOperation.getListener().onProcess(this.payoutKeeper.getSum().getBasicSum());
                    }
                    continue;
                }
                this.log.error((Object)("Unknown idx for " + e.getKey()));
            }
            this.log.info((Object)("Dispensed " + this.payoutKeeper));
            this.payoutOperation.getListener().onResult(this.payoutKeeper);
            this.payoutKeeper = null;
            this.payoutOperation = null;
        }
    }

    @Override
    public void clear(DispenseListener listener, int destination, Keeper keeper) throws HopperException, IOException {
        this.log.info((Object)"\u0420\u0443\u0447\u043d\u043e\u0435 \u043e\u043f\u0443\u0441\u0442\u043e\u0448\u0435\u043d\u0438\u0435");
    }

    @Override
    public void add(MoneyUnit mu, int count) throws HopperException, IOException {
    }

    @Override
    public Keeper getKeeper() {
        return null;
    }

    @Override
    public void payout(PayoutOperation po) throws HopperException, IOException {
        if (po == null || po.getListener() == null) {
            return;
        }
        if (this.payoutOperation != null) {
            this.log.error((Object)"Other payout operation in process");
            po.getListener().onError();
        }
        this.payoutOperation = po;
    }

    @Override
    public void flowDownCoins(Keeper target, DispenseListener listener) throws HopperException, IOException {
    }

    @Override
    public boolean isFlowDownSupported() {
        return false;
    }

    private void processDiagnostic() throws IOException {
        if (!this.enable && System.currentTimeMillis() - this.lastDiagnostic > 2000L) {
            this.lastDiagnostic = System.currentTimeMillis();
            byte[] res = this.api.diagnostic();
            if (res != null && res.length == 3) {
                if (res[0] == 21 && res[1] == 2) {
                    this.notifyStatus(ValidatorStatus.StackOut);
                } else {
                    this.notifyStatus(ValidatorStatus.Ok);
                }
            }
        }
    }
}

