/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.eu;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.coin.eu.EventListener;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;

public class EU9Api
implements ValidatorApi {
    public static final int CHANNEL_COUNT = 12;
    private final SerialPort port;
    private Logger log;
    private EventListener listener;
    private final Map<Boolean, SerialParams[]> serialParams;

    public EU9Api(SerialPort port, Logger log) {
        this.port = port;
        this.log = log;
        if (this.log == null) {
            this.log = Logger.getLogger((String)"coin");
        }
        port.setTimeout(50);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[0]);
    }

    @Override
    public void open() throws IOException {
        this.port.open();
    }

    public EventListener getListener() {
        return this.listener;
    }

    public void setListener(EventListener listener) {
        this.listener = listener;
    }

    @Override
    public void close() {
        this.port.close();
    }

    public void setEnable(boolean enable) throws IOException {
        this.port.setDTR(enable);
    }

    public void enableChannel(int channelId) throws IOException {
        this.operateChannel(channelId, 15);
    }

    public void disableChannel(int channelId) throws IOException {
        this.operateChannel(channelId, 143);
    }

    private void operateChannel(int channelId, int functionId) throws IOException {
        byte[] req = new byte[]{BU.c((int)226), BU.c((int)(4 + channelId * 7)), 85, BU.c((int)functionId), 0};
        req[4] = this.getCrc(req);
        this.log.debug((Object)(">>" + BU.toString((byte[])req)));
        this.port.write(req);
        byte[] res = this.readAnswer(req);
        this.log.debug((Object)("<<" + BU.toString((byte[])res)));
        if (!this.checkCrc(res)) {
            throw new IOException("Crc is not correct: " + BU.toString((byte[])res));
        }
        if (req[1] != res[1] || req[3] != res[2]) {
            throw new IOException("Answer is not correct, req=" + BU.toString((byte[])req) + ", res=" + BU.toString((byte[])res));
        }
    }

    private byte[] readAnswer(byte[] cmd) throws IOException {
        while (true) {
            int b;
            if ((b = this.port.readByte()) == 226) {
                byte[] res = this.port.read(4);
                byte[] ans = new byte[5];
                ans[0] = BU.c((int)226);
                System.arraycopy(res, 0, ans, 1, 4);
                return ans;
            }
            if (b >= 144 && b <= 153) {
                this.readEvent(BU.c((int)b));
                continue;
            }
            this.log.error((Object)("Read wrong byte: " + BU.toHex((int)b)));
        }
    }

    public void readEvent(int start) throws IOException {
        if (start == 0) {
            if (this.port.avaliable() > 0) {
                while ((start = this.port.readByte()) < 144 || start > 153) {
                    this.log.debug((Object)("Read wrong byte: " + BU.toHex((int)start)));
                }
                this.log.debug((Object)"Start byte is found");
            } else {
                return;
            }
        }
        byte[] res = this.port.read(4);
        byte[] ans = new byte[5];
        ans[0] = BU.c((int)start);
        System.arraycopy(res, 0, ans, 1, 4);
        this.log.debug((Object)("Read event: " + BU.toString((byte[])ans)));
        this.processEvent(ans);
    }

    private void processEvent(byte[] event) {
        if (BU.c((byte)event[0]) == 151) {
            this.log.info((Object)("Event: " + BU.toString((byte[])event)));
            this.log.info((Object)"Coin accepted");
            if (this.listener != null) {
                this.log.info((Object)"Notify listener");
                this.listener.onCoin(event[3]);
            }
        } else {
            this.log.debug((Object)("Unknown event: " + BU.toString((byte[])event)));
        }
    }

    private byte getCrc(byte[] res) {
        byte crc = 0;
        for (int i = 0; i < res.length - 1; ++i) {
            crc = (byte)(crc + BU.c((byte)res[i]));
        }
        return crc;
    }

    private boolean checkCrc(byte[] res) {
        byte crc = this.getCrc(res);
        return res[res.length - 1] == crc;
    }

    @Override
    public void test() throws IOException {
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        return new ValidatorInfo("-");
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.serialParams.get(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.log.info((Object)(this.port.getName() + " \u0418\u0449\u0443 EU9 \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438: " + params));
                this.port.putParams(params);
                this.port.open();
                this.disableChannel(0);
                this.log.info((Object)(this.port.getName() + " \u041d\u0430\u0448\u043b\u0438"));
                DeviceType deviceType = null;
                return deviceType;
            }
            catch (Exception ex) {
                this.log.error((Object)(this.port.getName() + " \u041d\u0435 \u043d\u0430\u0448\u043b\u0438"));
            }
            finally {
                this.port.close();
            }
        }
        throw new NoSuchDeviceException();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.EU9Coin;
    }
}

