/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin;

import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.gpt22.Driver;
import ru.softlogic.hardware.device.cashin.validator.itl.SspDriver;
import ru.softlogic.hardware.device.cashin.validator.stub.Driver2;
import ru.softlogic.hardware.device.cashin.validator.stub.Driver3;
import ru.softlogic.hardware.device.cashin.validator.stub.DriverManual;
import ru.softlogic.io.serial.SerialPort;

public class CashInFactory {
    public static Validator createInstance(DeviceType type, SerialPort serialPort) {
        Validator validator = null;
        String currency = SystemProp.getCurrency();
        if (currency == null) {
            currency = "RUB";
        }
        Logger.getLogger((String)"start").info((Object)("Cash acceptor currency: " + currency));
        switch (type.getDeviceClass()) {
            case CashAcceptor: {
                switch (type) {
                    case Ccnet: {
                        validator = new ru.softlogic.hardware.device.cashin.validator.ccnet.Driver(serialPort, currency);
                        break;
                    }
                    case Id003: {
                        validator = new ru.softlogic.hardware.device.cashin.validator.id003.Driver(serialPort, currency);
                        break;
                    }
                    case Ebds: {
                        validator = new ru.softlogic.hardware.device.cashin.validator.ebds.Driver(serialPort, currency);
                        break;
                    }
                    case Ict004: {
                        validator = new ru.softlogic.hardware.device.cashin.validator.ict004.Driver(serialPort, currency);
                        break;
                    }
                    case SmartPayout: {
                        validator = new ru.softlogic.hardware.device.cashin.validator.itl.Driver(serialPort, type);
                        break;
                    }
                    case ItlValidator: {
                        validator = new ru.softlogic.hardware.device.cashin.validator.itl.Driver(serialPort, type);
                        break;
                    }
                    case SspValidator: {
                        validator = new SspDriver(serialPort, type);
                        break;
                    }
                    case ValidatorStub: {
                        validator = new ru.softlogic.hardware.device.cashin.validator.stub.Driver();
                        break;
                    }
                    case ValidatorStub2: {
                        validator = new Driver2();
                        break;
                    }
                    case ValidatorStub2Pay: {
                        validator = new Driver3();
                        break;
                    }
                    case ValidatorStubManual: {
                        validator = new DriverManual();
                        break;
                    }
                    case Mdb: {
                        validator = new ru.softlogic.hardware.device.cashin.validator.mdb.Driver(serialPort, currency);
                        break;
                    }
                    case GPT22: {
                        validator = new Driver(serialPort, currency);
                    }
                }
                break;
            }
            case CoinAcceptor: {
                switch (type) {
                    case CCTalkCoin: {
                        validator = new ru.softlogic.hardware.device.cashin.coin.cctalk.Driver(serialPort);
                        break;
                    }
                    case EU9Coin: {
                        validator = new ru.softlogic.hardware.device.cashin.coin.eu.Driver(serialPort, currency);
                        break;
                    }
                    case MeiCF7000: {
                        validator = new ru.softlogic.hardware.device.cashin.coin.mei.Driver(serialPort, currency);
                        break;
                    }
                    case CurrenzaC2: {
                        validator = new ru.softlogic.hardware.device.cashin.coin.nriC2.Driver(serialPort, currency);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
            }
        }
        return validator;
    }
}

