/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin;

import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.system.util.ObjectReadWriteStream;

public class CashBox {
    private Keeper keeper;
    private DeviceClass deviceClass;
    private boolean diskError;
    private ObjectReadWriteStream tmpFile;
    private ObjectReadWriteStream mainFile;
    private Logger log = Logger.getLogger((String)"app");

    public CashBox(String fileName, DeviceClass deviceClass) {
        this.log.setAdditivity(false);
        this.log.info((Object)("\u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435: " + fileName + ", class=" + (Object)((Object)deviceClass)));
        try {
            this.tmpFile = new ObjectReadWriteStream(fileName + ".tmp");
            this.mainFile = new ObjectReadWriteStream(fileName);
            this.diskError = false;
        }
        catch (Exception ex) {
            this.diskError = true;
            this.log.error((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430", (Throwable)ex);
        }
        if (deviceClass == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DeviceClass");
        }
        if (deviceClass != DeviceClass.CashAcceptor && deviceClass != DeviceClass.CoinAcceptor) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d DeviceClass");
        }
        this.deviceClass = deviceClass;
        this.readData();
    }

    public boolean isDiskError() {
        return this.diskError;
    }

    public synchronized void addCash(CashUnit cu) {
        if (cu == null) {
            throw new IllegalArgumentException("MoneyUnit \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435\u043f\u0443\u0441\u0442\u043e\u0439");
        }
        this.keeper.addCash(cu);
        this.saveData();
    }

    public synchronized void addCash(CashUnit cu, int count) {
        if (cu == null) {
            throw new IllegalArgumentException("MoneyUnit \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435\u043f\u0443\u0441\u0442\u043e\u0439");
        }
        this.keeper.addCash(cu, count);
        this.saveData();
    }

    public synchronized void removeCash(CashUnit cu) {
        if (cu == null) {
            throw new IllegalArgumentException("MoneyUnit \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435\u043f\u0443\u0441\u0442\u043e\u0439");
        }
        this.keeper.removeCash(cu);
        this.saveData();
    }

    public synchronized void sub(Keeper subKeeper) {
        if (subKeeper == null) {
            throw new IllegalArgumentException("Keeper");
        }
        for (CashUnit cu : subKeeper.getCashUnits().keySet()) {
            int cnt = (Integer)subKeeper.getCashUnits().get(cu);
            if (cnt <= 0) continue;
            this.keeper.removeCash(cu, cnt);
        }
        this.saveData();
    }

    public synchronized Keeper getKeeper() {
        return this.keeper;
    }

    public synchronized Keeper collect() {
        Keeper result = this.keeper;
        this.keeper = new Keeper();
        this.saveData();
        return result;
    }

    public synchronized Keeper collect(CashUnit cu) {
        if (cu == null) {
            return this.collect();
        }
        Integer count = (Integer)this.keeper.getCashUnits().get(cu);
        Keeper result = new Keeper();
        if (count != null) {
            result.addCash(cu, count.intValue());
            this.keeper.removeCash(cu, count.intValue());
        }
        this.saveData();
        return result;
    }

    public DeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    private void readData() {
        try {
            this.log.info((Object)"Read main cashbox store");
            if (this.mainFile != null) {
                this.keeper = (Keeper)this.mainFile.readObject();
            }
        }
        catch (Throwable ex) {
            this.log.error((Object)("Error on read main store: " + ex));
        }
        if (this.keeper == null) {
            try {
                this.log.info((Object)"Read secondary cashbox store");
                if (this.tmpFile != null) {
                    this.keeper = (Keeper)this.tmpFile.readObject();
                }
            }
            catch (Throwable ex1) {
                this.log.info((Object)("Error on read secondary store: " + ex1));
            }
        }
        if (this.keeper == null) {
            this.keeper = new Keeper();
            this.keeper.setCreated(null);
        }
        this.log.info((Object)("Cashbox contains: " + (Object)((Object)this.deviceClass) + ": " + this.keeper));
    }

    private boolean saveData() {
        String path = "tmp";
        try {
            if (this.tmpFile != null) {
                this.tmpFile.writeObject((Serializable)this.keeper);
            }
            path = "main";
            if (this.mainFile != null) {
                this.mainFile.writeObject((Serializable)this.keeper);
            }
        }
        catch (IOException ex) {
            this.diskError = true;
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445(" + path + "): "), (Throwable)ex);
            return false;
        }
        return true;
    }

    public void close() {
        if (this.mainFile != null) {
            try {
                this.mainFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.tmpFile != null) {
            try {
                this.tmpFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

