/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.textfield;

import javax.swing.JLabel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui2.screen.textfield.FieldListener;
import ru.softlogic.input.model.field.text.TextField;

public class ValidateTextFieldListener
implements FieldListener {
    protected ClickButton button;
    protected JLabel errorLabel;
    protected TextField tf;

    public ValidateTextFieldListener(ClickButton button, JLabel errorLabel, TextField tf) {
        if (button == null) {
            throw new NullPointerException("ClickButton");
        }
        if (errorLabel == null) {
            throw new NullPointerException("JLabel");
        }
        if (tf == null) {
            throw new NullPointerException("TextField");
        }
        this.button = button;
        this.errorLabel = errorLabel;
        this.tf = tf;
    }

    @Override
    public void onChange(String value) {
        boolean valid = this.tf.getValidator().validate(value);
        if (!valid && this.tf.getFailRegex() != null && !this.tf.getFailRegex().isEmpty()) {
            try {
                this.button.setEnabled(value.matches(this.tf.getFailRegex()));
            }
            catch (Exception ex) {
                this.button.setEnabled(false);
            }
        } else {
            this.button.setEnabled(valid);
        }
        this.errorLabel.setVisible(value.length() >= this.tf.getMaxLength() && !valid);
    }
}

