/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.textfield;

import java.util.HashSet;
import java.util.Set;
import ru.softlogic.gui2.screen.textfield.FieldListener;
import ru.softlogic.gui2.screen.textfield.InputFieldModel;
import ru.softlogic.input.model.field.text.Filter;

public class NumericFieldModel
implements InputFieldModel {
    private int decimalCount;
    private int unitCount;
    private boolean readOnly;
    private Filter filter;
    private String regex;
    private String value;
    private Set<FieldListener> listeners;

    public NumericFieldModel(int unitCount, int decimalCount, boolean readOnly, Filter filter) {
        if (decimalCount < 0) {
            throw new IllegalArgumentException("Decimal count must be positive");
        }
        if (unitCount < 0) {
            throw new IllegalArgumentException("Unit count must be positive");
        }
        if (filter == null) {
            throw new NullPointerException("Filter is not specified");
        }
        this.decimalCount = decimalCount;
        this.unitCount = unitCount;
        this.readOnly = readOnly;
        this.filter = filter;
        this.regex = decimalCount > 0 ? "^\\d{1," + unitCount + "}((\\.|,)\\d{0," + decimalCount + "})?$" : "^[0-9]{1}\\d{0," + (unitCount - 1) + "}$";
        this.value = "";
        this.listeners = new HashSet<FieldListener>();
    }

    @Override
    public void add(char ch) {
        if (!this.readOnly) {
            this._add(ch, true);
        }
    }

    @Override
    public void clear() {
        if (!this.readOnly) {
            this.value = "";
            this.notifyListeners();
        }
    }

    @Override
    public void clearLast() {
        if (!this.readOnly && this.value.length() > 0) {
            this.value = this.value.substring(0, this.value.length() - 1);
            this.notifyListeners();
        }
    }

    @Override
    public void setValue(String value) {
        if (value != null && !value.isEmpty()) {
            this.value = "";
            for (char ch : value.toCharArray()) {
                this._add(ch, false);
            }
            this.notifyListeners();
        } else {
            this.clear();
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getClearValue() {
        return this.value;
    }

    @Override
    public void addListener(FieldListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void notifyListeners() {
        for (FieldListener fl : this.listeners) {
            fl.onChange(this.getValue());
        }
    }

    private void _add(char ch, boolean doNotify) {
        String newValue = this.value + ch;
        if (newValue.matches(this.regex) && !newValue.matches("^0{2,}") && this.filter.isAllowed(ch, this.value.length())) {
            this.value = newValue;
            if (doNotify) {
                this.notifyListeners();
            }
        }
    }
}

