/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.listener.ng;

import java.util.LinkedHashMap;
import java.util.Map;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.gui2.screen.listener.ng.ActionNotifier;

public class BarcodeActionNotifier
implements ActionNotifier {
    private ScreenListener listener;
    private Map<String, Object> barcodeData;
    private int lock;

    public void setBarcodeData(Map<String, Object> barcodeData) {
        this.barcodeData = barcodeData;
    }

    public void setListener(ScreenListener listener) {
        this.listener = listener;
    }

    @Override
    public void init() {
        this.unlock();
    }

    public synchronized void lock() {
        this.lock = 1;
    }

    @Override
    public synchronized void notify(String type) {
        if (this.lock == 0) {
            this.lock = 1;
            if (this.listener != null) {
                Map<String, Object> data = this.barcodeData;
                if (data == null) {
                    data = new LinkedHashMap<String, Object>();
                }
                this.listener.onAction(type, data, new LocalCancelListener());
            }
        } else {
            ++this.lock;
            if (this.lock == 3 || this.lock % 10 == 0) {
                ProblemNotifier.getDefaultNotifier().onProblem("BarcodeActionNotifier: Try " + type + " action on locked notifier, count:" + this.lock);
            }
            if (this.lock >= 10) {
                ProblemNotifier.getDefaultNotifier();
                ProblemNotifier.requestRestart((String)("Action blocked=" + type));
            }
        }
    }

    private synchronized void unlock() {
        this.lock = 0;
    }

    private class LocalCancelListener
    implements Runnable {
        private LocalCancelListener() {
        }

        @Override
        public void run() {
            BarcodeActionNotifier.this.unlock();
        }
    }
}

