/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.listener;

import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JButton;
import org.apache.log4j.Logger;
import ru.softlogic.gui2.screen.ComboBoxItem;
import ru.softlogic.gui2.screen.listener.SelectorNextListener;
import ru.softlogic.gui2.screen.listener.SimpleCancelListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.field.selector.SelectorItem;

public class SelectorNextMultyServiceListener
extends SelectorNextListener {
    private Integer currentServiceId;
    private InputElement keeperLogin;
    private InputElement keeperTemplateName;

    public void setCurrentServiceId(int ncurrentServiceId) {
        this.currentServiceId = ncurrentServiceId;
    }

    public void setKeeperLogin(InputElement keeperLogin) {
        this.keeperLogin = keeperLogin;
    }

    public void setKeeperTemplateName(InputElement keeperTemplateName) {
        this.keeperTemplateName = keeperTemplateName;
    }

    @Override
    public void onSelect(ComboBoxItem item, JButton button) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        if (item != null) {
            Object obj;
            SelectorItem si = item.getItem();
            Integer selectedServiceId = 0;
            for (InputElement ie : si.getData().getElements()) {
                if (!"#service-id".equals(ie.getKey()) || ie.getValue() == null || ie.getValue().isEmpty()) continue;
                selectedServiceId = Integer.parseInt(ie.getValue());
                break;
            }
            if (selectedServiceId == 0) {
                Logger.getLogger((String)"gui").error((Object)"Selected item has no #service-id");
            }
            if (si.getData() != null) {
                Data d = si.getData();
                StoreHelper.mergeData(data, (List)d.getElements());
                if (d.getNestedData() != null) {
                    data.put(d.getNestedData().getId(), d.getNestedData().getData());
                }
                if (d.getSum() != null) {
                    data.put("#sum", d.getSum());
                }
            }
            if (si.getCustomData() != null) {
                data.putAll(si.getCustomData());
            }
            if ((obj = data.get("template-id")) != null) {
                InputElement ie;
                ie = (InputElement)obj;
                ie.setFlags(515);
                data.put("template-id", ie);
            }
            if (this.keeperLogin != null) {
                data.put("keeper.login", this.keeperLogin);
            }
            if (this.keeperTemplateName != null) {
                data.put("keeper.template.name", this.keeperTemplateName);
            }
            if (this.listener != null) {
                button.setEnabled(false);
                if (selectedServiceId.equals(this.currentServiceId)) {
                    this.listener.onAction("Next", data, new SimpleCancelListener(button));
                } else {
                    data.put("#service-id", selectedServiceId);
                    this.listener.onAction("Redirect", data, new SimpleCancelListener(button));
                }
            }
        } else {
            button.setEnabled(false);
            this.listener.onAction("Next", data, new SimpleCancelListener(button));
        }
    }
}

