/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.input;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.input.InputComponent;
import ru.softlogic.gui2.screen.input.InputComponentListener;
import ru.softlogic.gui2.screen.textfield.FieldListener;
import ru.softlogic.gui2.screen.textfield.InputFieldModel;
import ru.softlogic.gui2.screen.textfield.TextFieldModel;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.text.TextField;

public abstract class TextInputComponent
implements InputComponent {
    protected TextField field;
    protected JLabel component;
    protected InputFieldModel model;
    protected InputComponentListener listener;

    public TextInputComponent(JLabel component, TextField field, Object value, InputComponentListener listener) {
        this.field = field;
        this.listener = listener;
        this.component = component;
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UserAction.getInstance().update();
                TextInputComponent.this.getFocus();
            }
        });
        this.model = new TextFieldModel(field.getMaxLength(), field.getPrefix(), field.getPostfix(), field.isReadOnly(), field.getFilter());
        this.model.addListener(new FieldListener(){

            @Override
            public void onChange(String value) {
                if (TextInputComponent.this.field.isSecure() && value != null) {
                    value = value.replaceAll("\\W{1}|\\w{1}", "*");
                }
                TextInputComponent.this.component.setText(TextInputComponent.this.field.getDataFormatter().format(value).trim());
                TextInputComponent.this.listener.onChange();
            }
        });
        this.model.setValue(field.getValue());
    }

    @Override
    public boolean isValid() {
        boolean valid = this.field.getValidator().validate(this.model.getValue());
        this.setWarning(!this.model.getValue().isEmpty() && !valid);
        if (!valid && this.field.getFailRegex() != null && !this.field.getFailRegex().isEmpty() && this.model.getValue().matches(this.field.getFailRegex())) {
            valid = true;
        }
        return valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), null, this.model.getClearValue(), this.field.getModificator().modify(this.model.getValue()), this.component.getText(), 0);
        ie.setFlags(this.field.getFlags());
        if (!this.field.getValidator().validate(this.model.getValue()) && this.field.getFailRegex() != null && !this.field.getFailRegex().isEmpty() && this.model.getValue().matches(this.field.getFailRegex())) {
            data.put("#invalid", "true");
        }
        data.put(this.field.getId(), ie);
    }

    @Override
    public void update(Map<String, Object> data) {
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public String getHelp() {
        return this.field.getHelp();
    }

    public InputFieldModel getModel() {
        return this.model;
    }

    public TextField getField() {
        return this.field;
    }

    public String toString() {
        return "TextInputComponent{field=" + this.field + '}';
    }
}

