/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.input;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.ComboBoxItem;
import ru.softlogic.gui2.screen.input.InputComponent;
import ru.softlogic.gui2.screen.input.InputComponentListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;

public class SelectorInputComponent
implements InputComponent {
    private SelectorField field;
    private JComboBox component;
    private InputComponentListener listener;

    public SelectorInputComponent(JComboBox component, SelectorField field, Object value, InputComponentListener listener, int height) {
        this.component = component;
        this.field = field;
        this.listener = listener;
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UserAction.getInstance().update();
                SelectorInputComponent.this.getFocus();
            }
        });
        component.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectorInputComponent.this.listener.onChange();
            }
        });
        ComboBoxItem[] items = new ComboBoxItem[field.getItems().size()];
        for (int i = 0; i < items.length; ++i) {
            ComboBoxItem cbi;
            SelectorItem si = (SelectorItem)field.getItems().get(i);
            String title = "<html><table><td style=\"height:" + height + "px;text-align:left;vertical-align:middle\">" + si.getTitle() + "</td></table>";
            items[i] = cbi = new ComboBoxItem(si.getValue(), si.getTitle(), title, si);
        }
        component.setModel(new DefaultComboBoxModel<ComboBoxItem>(items));
        if (value != null && value instanceof InputElement) {
            InputElement ie = (InputElement)value;
            if (ie.getValue() != null && ie.getValueTitle() != null) {
                String title = "<html><table><td style=\"height:" + height + "px;text-align:left;vertical-align:middle\">" + ie.getValueTitle() + "</td></table>";
                component.setSelectedItem(new ComboBoxItem(ie.getValue(), ie.getValueTitle(), title, null));
            } else {
                component.setSelectedItem(null);
            }
        } else {
            component.setSelectedItem(null);
        }
    }

    @Override
    public boolean isValid() {
        return this.component.getSelectedItem() != null;
    }

    @Override
    public String getHelp() {
        return this.field.getHelp();
    }

    @Override
    public void putData(Map<String, Object> data) {
        ComboBoxItem cbi;
        SelectorItem si;
        Object obj = this.component.getSelectedItem();
        if (obj != null && (si = (cbi = (ComboBoxItem)obj).getItem()) != null) {
            InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), null, cbi.getValue(), cbi.getValue(), cbi.getTitle(), 0);
            ie.setFlags(this.field.getFlags());
            data.put(this.field.getId(), ie);
            if (si.getData() != null) {
                Data d = si.getData();
                if (data != null && d.getElements() != null) {
                    for (InputElement el : d.getElements()) {
                        data.put(el.getKey(), el);
                    }
                }
                if (d.getNestedData() != null) {
                    data.put(d.getNestedData().getId(), d.getNestedData().getData());
                }
                if (d.getSum() != null) {
                    data.put("#sum", d.getSum());
                }
            }
            if (si.getCustomData() != null) {
                data.putAll(si.getCustomData());
            }
        }
    }

    @Override
    public void update(Map<String, Object> data) {
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void getFocus() {
        this.listener.onSelect(this, null, null);
    }

    @Override
    public void onLostFocus() {
    }

    public SelectorInputComponent(SelectorField field) {
        this.field = field;
    }

    public String toString() {
        return "SelectorInputComponent{field=" + this.field + '}';
    }

    @Override
    public void setWarning(boolean warning) {
    }
}

