/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.input;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.input.InputComponent;
import ru.softlogic.gui2.screen.input.InputComponentListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.date.DateField;

public class DateInputComponent
implements InputComponent {
    protected DateField field;
    protected JLabel component;
    protected InputComponentListener listener;
    protected boolean selected;
    protected boolean warning;
    private Date selectDate;

    public DateInputComponent(JLabel component, DateField field, Object oValue, InputComponentListener listener) {
        this.field = field;
        this.listener = listener;
        this.component = component;
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UserAction.getInstance().update();
                DateInputComponent.this.getFocus();
            }
        });
        this.selectDate = field.getValue();
        if (this.selectDate != null && field.getFormaterTitle() != null) {
            component.setText(field.getFormaterTitle().format(this.selectDate));
        }
        if (field.getOnTop() == null || field.getOnTop().isEmpty()) {
            field.setOnTop("date/popup");
        }
    }

    @Override
    public boolean isValid() {
        return !this.component.getText().isEmpty() && this.selectDate != null || !this.field.isRequired();
    }

    @Override
    public void putData(Map<String, Object> data) {
        if (this.selectDate != null) {
            InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), this.field.getTitleId(), this.field.getFormater().format(this.selectDate), this.field.getFormaterTitle().format(this.selectDate), 0);
            ie.setFlags(this.field.getFlags());
            data.put(this.field.getId(), ie);
        }
    }

    public String toString() {
        return "DateInputComponent1{field=" + this.field + '}';
    }

    @Override
    public void getFocus() {
        this.selected = true;
        this.listener.onSelect(this, null, null);
    }

    @Override
    public void onLostFocus() {
        this.selected = false;
    }

    @Override
    public void setWarning(boolean warning) {
        this.warning = warning;
    }

    @Override
    public void update(Map<String, Object> data) {
        InputElement ie;
        String value;
        Object obj = data.get(this.field.getId());
        if (obj instanceof InputElement && (value = (ie = (InputElement)obj).getValue()) != null && !value.isEmpty()) {
            try {
                this.selectDate = this.field.getFormater().parse(value);
                this.component.setText(this.field.getFormaterTitle().format(this.selectDate));
                this.listener.onChange();
                return;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.component.setText("");
        this.listener.onChange();
    }

    @Override
    public String getHelp() {
        return this.field.getHelp();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }
}

