/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.input;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.input.InputComponent;
import ru.softlogic.gui2.screen.input.InputComponentListener;
import ru.softlogic.gui2.screen.input.JScrollPopupMenu;
import ru.softlogic.gui2.screen.textfield.AutoCompleteFieldModel;
import ru.softlogic.gui2.screen.textfield.FieldListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;

public abstract class AutoCompleteInputComponentWithoutPopup
implements InputComponent {
    protected AutoCompleteField field;
    protected JLabel component;
    protected AutoCompleteFieldModel model;
    protected InputComponentListener listener;
    protected boolean selected;
    protected boolean warning;
    protected InputElement complete;
    protected JScrollPopupMenu autoCompletePopup;

    public AutoCompleteInputComponentWithoutPopup(JLabel component, AutoCompleteField field, Object oValue, InputComponentListener listener) {
        this.field = field;
        this.listener = listener;
        this.component = component;
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UserAction.getInstance().update();
                AutoCompleteInputComponentWithoutPopup.this.getFocus();
            }
        });
        this.model = new AutoCompleteFieldModel();
        InputElement val = null;
        this.model.setValue("");
        val = oValue instanceof InputElement ? (InputElement)oValue : field.getDataStore().getDefaultElement();
        if (val != null) {
            this.complete = val;
            this.model.setValue(val.getValueTitle());
            component.setText(val.getValueTitle());
        }
        this.model.addListener(new FieldListener(){

            @Override
            public void onChange(String value) {
                AutoCompleteInputComponentWithoutPopup.this.complete = null;
                AutoCompleteInputComponentWithoutPopup.this.modelChanged(value);
                AutoCompleteInputComponentWithoutPopup.this.component.setText(value);
                AutoCompleteInputComponentWithoutPopup.this.listener.onChange();
            }
        });
    }

    @Override
    public boolean isValid() {
        return this.complete != null || this.field.isOptional();
    }

    @Override
    public void getFocus() {
        this.modelChanged(this.model.getValue());
    }

    @Override
    public void putData(Map<String, Object> data) {
        if (this.complete != null) {
            this.complete.setKey(this.field.getId());
            this.complete.setKeyTitle(this.field.getTitle());
            this.complete.setKeyTitleId(this.field.getTitleId());
            data.put(this.field.getId(), this.complete);
        }
    }

    @Override
    public void update(Map<String, Object> data) {
    }

    public String toString() {
        return "AutoCompleteInputComponent{field=" + this.field + '}';
    }

    @Override
    public String getHelp() {
        return this.field.getHelp();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    public void modelChanged(String value) {
        if (value != null && !value.isEmpty() && value.length() >= this.field.getMinChars() && this.component.isEnabled()) {
            List result = this.field.getDataStore().getElements(value, this.field.getMaxItems());
            for (InputElement ie : result) {
                if (!value.equals(ie.getValueTitle())) continue;
                this.complete = ie;
                break;
            }
            if (this.complete != null) {
                result.remove(this.complete);
            }
            if (result.size() > 0 && result.size() <= this.field.getMaxItems()) {
                this.autoCompletePopup.clearItems();
                for (InputElement ie : result) {
                    this.autoCompletePopup.add(new JMenuItem(ie.getValueTitle()));
                }
                if (SwingUtilities.getWindowAncestor(this.component) != null) {
                    if (this.autoCompletePopup.getItemsCount() == 0) {
                        this.autoCompletePopup.hide();
                    } else if (this.autoCompletePopup.isVisible()) {
                        this.autoCompletePopup.hide();
                        this.autoCompletePopup.show();
                    } else {
                        this.autoCompletePopup.show();
                    }
                }
            }
        }
    }
}

