/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen;

import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.components.button.IconifiedClickButton;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class ScreenHelper {
    private static final Logger log = Logger.getLogger((String)"pay");

    public static void initNext(ClickButton next, Map<String, ButtonInit> map, String defaultText) {
        if (map != null) {
            ButtonInit bi = map.get("Next");
            if (bi == null) {
                bi = map.get("Next".toLowerCase());
            }
            if (bi != null && bi.getName() != null) {
                next.setText(bi.getName());
                next.setEnabled(false);
                return;
            }
        }
        next.setText(defaultText);
        next.setVisible(true);
        next.setEnabled(false);
    }

    public static void initNext(IconifiedClickButton next, Map<String, ButtonInit> map, String defaultText) {
        if (map != null) {
            ButtonInit bi = map.get("Next");
            if (bi == null) {
                bi = map.get("Next".toLowerCase());
            }
            if (bi != null && bi.getName() != null) {
                next.getTitleLabel().setText(bi.getName());
                next.setEnabled(false);
                return;
            }
        }
        next.getTitleLabel().setText(defaultText);
        next.setVisible(true);
        next.setEnabled(false);
    }

    public static void initButton(ClickButton button, ScreenDescription sd, String buttonType, String defaultText) {
        Map map = sd.getButtons();
        if (map != null) {
            ButtonInit bi = (ButtonInit)map.get(buttonType);
            if (bi == null) {
                bi = (ButtonInit)map.get(buttonType.toLowerCase());
            }
            if (bi != null) {
                button.setText(bi.getName() == null ? defaultText : bi.getName());
                button.setEnabled(bi.isEnable());
            } else {
                button.setText(defaultText);
                button.setEnabled(false);
            }
        } else {
            button.setText(defaultText);
            button.setEnabled(true);
        }
    }

    public static void initButton(IconifiedClickButton button, ScreenDescription sd, String buttonType, String defaultText) {
        Map map = sd.getButtons();
        if (map != null) {
            ButtonInit bi = (ButtonInit)map.get(buttonType);
            if (bi == null) {
                bi = (ButtonInit)map.get(buttonType.toLowerCase());
            }
            if (bi != null) {
                button.getTitleLabel().setText(bi.getName() == null ? defaultText : bi.getName());
                button.setEnabled(bi.isEnable());
                return;
            }
            button.getTitleLabel().setText(defaultText);
            button.setEnabled(false);
        } else {
            button.getTitleLabel().setText(defaultText);
            button.setEnabled(true);
        }
    }

    public static ScreenDescription processBack(ScreenDescription sd, boolean firstScreen, boolean hasParent) {
        Map buttons = sd.getButtons();
        if (buttons != null) {
            ButtonInit bi = (ButtonInit)buttons.get("Prev");
            if (bi == null) {
                bi = (ButtonInit)buttons.get("prev");
            }
            if (bi != null) {
                bi.setEnable(!firstScreen || hasParent);
            }
        }
        return sd;
    }
}

