/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.reference.menu.MenuItem;

public class CommonScreenStore {
    private static final Map<String, SoftReference<CommonScreen>> SCREENS = new HashMap<String, SoftReference<CommonScreen>>();
    private static final Logger log = Logger.getLogger((String)"gui");

    public static CommonScreen getScreen(String type) {
        return CommonScreenStore.getScreen(type, null);
    }

    public static CommonScreen getScreen(String type, String decor) {
        if (type == null || type.isEmpty()) {
            return null;
        }
        SoftReference<CommonScreen> ref = SCREENS.get(type + "_" + decor);
        CommonScreen cs = null;
        if (ref != null) {
            cs = ref.get();
        }
        if (cs != null) {
            return cs;
        }
        cs = ComponentFactory.getInstance().create(type, decor);
        if (cs != null) {
            SCREENS.put(type + "_" + decor, new SoftReference<CommonScreen>(cs));
        }
        return cs;
    }

    public static CommonScreen getSumScreen(SumScreenDescription sd, MenuItem mi, boolean updateScreenDescription) {
        return CommonScreenStore.getSumScreen(sd, mi, "sum", updateScreenDescription);
    }

    public static CommonScreen getSumScreen(SumScreenDescription sd, MenuItem mi, String baseScreenType, boolean updateScreenDescription) {
        log.info((Object)("SumScreenDescription: " + sd.getType() + "/" + sd.getDecor()));
        log.info((Object)("MenuItem: " + (mi != null ? mi.getScreenType() + "/" + mi.getDecor() : "null")));
        log.info((Object)("baseScreenType: " + baseScreenType));
        if (baseScreenType == null || baseScreenType.isEmpty()) {
            baseScreenType = "sum";
        }
        String type = sd.getType();
        String decor = sd.getDecor();
        if (mi == null || !CommonScreenStore.isValid(mi.getScreenType()) && !CommonScreenStore.isValid(mi.getDecor())) {
            return CommonScreenStore.getScreen(type, decor);
        }
        boolean canUseMISettings = (!CommonScreenStore.isValid(type) || baseScreenType.equals(type)) && !CommonScreenStore.isValid(decor);
        CommonScreen cs = null;
        if (canUseMISettings) {
            type = mi.getScreenType() != null ? mi.getScreenType() : baseScreenType;
            decor = mi.getDecor();
            cs = CommonScreenStore.getScreen(type, decor);
        }
        if (cs == null) {
            type = sd.getType();
            decor = sd.getDecor();
            cs = CommonScreenStore.getScreen(type, decor);
        }
        log.info((Object)("getSumScreen: " + type + "/" + decor));
        if (updateScreenDescription) {
            sd.setType(type);
            sd.setDecor(decor);
        }
        return cs;
    }

    private static boolean isValid(String src) {
        return src != null && !src.isEmpty();
    }
}

