/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.keyboard.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import ru.softlogic.gui2.keyboard.KeySettings;
import ru.softlogic.gui2.keyboard.SetConfiguration;
import ru.softlogic.gui2.keyboard.loader.SetLoader;

public class FileSetLoader
implements SetLoader {
    private File path;
    private String keyboardId;

    public FileSetLoader(File path, String keyboardId) {
        if (path == null) {
            throw new NullPointerException("File");
        }
        if (keyboardId == null) {
            throw new NullPointerException("KeyboardId");
        }
        this.path = path;
        this.keyboardId = keyboardId;
    }

    @Override
    public SetConfiguration readLayout(String set) {
        if (set == null) {
            return null;
        }
        try {
            List strs = FileUtils.readLines((File)new File(this.path, "/" + this.keyboardId + "/set_" + set + ".kbl"), (String)"utf-8");
            return new SetConfiguration(strs);
        }
        catch (IOException ex) {
            return new SetConfiguration(new LinkedList<String>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, KeySettings> readKeySettings(Locale locale) {
        InputStreamReader isr = null;
        try {
            String loc = "";
            if (locale != null) {
                if (new File(this.path, "/" + this.keyboardId + "/sys_messages_" + locale.toString() + ".kbl").exists()) {
                    loc = "_" + locale.toString();
                } else if (new File(this.path, "/" + this.keyboardId + "/sys_messages_" + locale.getLanguage() + ".kbl").exists()) {
                    loc = "_" + locale.getLanguage();
                } else if (new File(this.path, "/" + this.keyboardId + "/sys_messages_" + Locale.getDefault().toString() + ".kbl").exists()) {
                    loc = "_" + Locale.getDefault().toString();
                } else if (new File(this.path, "/" + this.keyboardId + "/sys_messages_" + Locale.getDefault().getLanguage() + ".kbl").exists()) {
                    loc = "_" + Locale.getDefault().getLanguage();
                }
            }
            isr = new InputStreamReader((InputStream)new FileInputStream(new File(this.path, "/" + this.keyboardId + "/sys_messages" + loc + ".kbl")), "utf-8");
            Properties prop = new Properties();
            prop.load(isr);
            HashMap<String, KeySettings> keys = new HashMap<String, KeySettings>();
            for (String key : prop.stringPropertyNames()) {
                if (!key.startsWith("key.") || key.endsWith(".icon")) continue;
                String name = key.substring(4);
                keys.put(name, new KeySettings(prop.getProperty(key), prop.getProperty(key + ".icon")));
            }
            HashMap<String, KeySettings> hashMap = keys;
            IOUtils.closeQuietly((Reader)isr);
            return hashMap;
        }
        catch (IOException ex) {
            HashMap<String, KeySettings> hashMap = new HashMap<String, KeySettings>();
            return hashMap;
        }
        finally {
            IOUtils.closeQuietly(isr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> readKeyMapping() {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(new File(this.path, "/" + this.keyboardId + "/sys_config.kbl")), "utf-8");
            Properties prop = new Properties();
            prop.load(isr);
            HashMap<String, String> keys = new HashMap<String, String>();
            for (String key : prop.stringPropertyNames()) {
                keys.put(key, prop.getProperty(key));
            }
            HashMap<String, String> hashMap = keys;
            IOUtils.closeQuietly((Reader)isr);
            return hashMap;
        }
        catch (IOException ex) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            return hashMap;
        }
        finally {
            IOUtils.closeQuietly(isr);
        }
    }
}

