/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.keyboard.letter;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui2.keyboard.GuiKeyboard;
import ru.softlogic.gui2.keyboard.letter.BaseLetterKeyboard;
import ru.softlogic.gui2.keyboard.letter.StandartKeyFactory;
import ru.softlogic.gui2.keyboard.loader.SetLoader;

public class CompactLetterKeyboard
extends BaseLetterKeyboard {
    public CompactLetterKeyboard(StandartKeyFactory factory, SetLoader setLoader, GuiKeyboard digitalKeyboard) {
        super(factory, setLoader, digitalKeyboard);
        double[] cols = new double[17];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = i % 2 == 0 ? 0.1111111111111111 : -1.0;
        }
        double[] rows = new double[]{0.2, -1.0, 0.2, -1.0, 0.2, -1.0, 0.2, -1.0, 0.2};
        this.main.setLayout((LayoutManager)new TableLayout(cols, rows));
        this.letters = new ClickButton[4][];
        for (int i = 0; i < 4; ++i) {
            this.letters[i] = new ClickButton[9];
            for (int j = 0; j < this.letters[i].length; ++j) {
                ClickButton cb = factory.createKey(i, j);
                cb.addActionListener(this.actionListener);
                this.letters[i][j] = cb;
                this.main.add((Component)cb, "" + j * 2 + "," + i * 2);
            }
        }
        this.backspace.addActionListener(this.actionListener);
        this.caps.setForeground(Color.red);
        this.main.add((Component)this.caps, "0,8");
        this.main.add((Component)this.space, "2,8,10,8");
        this.main.add((Component)this.set1, "12,8");
        this.main.add((Component)this.set2, "14,8");
        this.main.add((Component)this.set3, "16,8");
    }
}

