/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.keyboard.letter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.components.button.LabeledClickButton;
import ru.softlogic.gui2.keyboard.GuiKeyboard;
import ru.softlogic.gui2.keyboard.KeySettings;
import ru.softlogic.gui2.keyboard.KeyboardListener;
import ru.softlogic.gui2.keyboard.SetConfiguration;
import ru.softlogic.gui2.keyboard.letter.StandartKeyFactory;
import ru.softlogic.gui2.keyboard.loader.SetLoader;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;

public class BaseLetterKeyboard
implements GuiKeyboard {
    private SetLoader setLoader;
    private GuiKeyboard digitalKeyboard;
    protected JPanel main;
    protected ClickButton[][] letters;
    protected LabeledClickButton set1;
    protected LabeledClickButton set2;
    protected LabeledClickButton set3;
    protected LabeledClickButton caps;
    protected LabeledClickButton space;
    protected ClickButton enter;
    protected ClickButton backspace;
    protected ActionListener actionListener;
    private Set<KeyboardListener> listeners;
    private Locale locale;
    private Keyboard keyboard;
    private String currentSetName;
    private KeyboardCase currentCase;
    private SetConfiguration currentSet;
    private Map<String, String> keyMapping;

    public BaseLetterKeyboard(StandartKeyFactory factory, SetLoader setLoader, GuiKeyboard digitalKeyboard) {
        if (setLoader == null) {
            throw new NullPointerException("SetLoader");
        }
        this.setLoader = setLoader;
        this.digitalKeyboard = digitalKeyboard;
        this.main = new JPanel();
        this.actionListener = new LocalActionListener();
        this.backspace = factory.createBackspace();
        this.backspace.addActionListener(this.actionListener);
        this.enter = factory.createEnter();
        this.enter.addActionListener(this.actionListener);
        this.caps = factory.createCaps();
        this.caps.addActionListener(new CapsActionListener());
        this.set1 = factory.createSet1();
        this.set1.addActionListener(new Set1ActionListener());
        this.space = factory.createSpace();
        this.space.addActionListener(this.actionListener);
        this.set2 = factory.createSet2();
        this.set2.addActionListener(new Set2ActionListener());
        this.set3 = factory.createSet3();
        this.set3.addActionListener(new Set3ActionListener());
        this.set1.setEnabled(false);
        this.set2.setEnabled(false);
        this.set3.setEnabled(false);
        this.listeners = new HashSet<KeyboardListener>();
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!locale.equals(this.locale)) {
            this.locale = locale;
            Map<String, KeySettings> keys = this.setLoader.readKeySettings(locale);
            if (keys != null) {
                this.initButton(this.space, keys.get("space"));
                this.initButton(this.set1, keys.get("set1"));
                this.initButton(this.set2, keys.get("set2"));
                this.initButton(this.set3, keys.get("set3"));
                this.initButton(this.caps, keys.get("caps"));
                this.initButton(this.enter, keys.get("enter"));
            }
        }
    }

    @Override
    public void init(Keyboard keyboard) {
        if (this.keyboard == keyboard) {
            return;
        }
        this.keyboard = keyboard;
        if (this.keyMapping == null) {
            this.keyMapping = this.setLoader.readKeyMapping();
        }
        this.setAccessible();
        this.currentSetName = null;
        if (keyboard.getLayoutNames() != null && !keyboard.getLayoutNames().isEmpty()) {
            this.currentSetName = (String)keyboard.getLayoutNames().get(0);
        }
        this.currentCase = keyboard.getDefaultCase();
        this.refreshSet();
        if (this.digitalKeyboard != null) {
            this.digitalKeyboard.init(keyboard);
        }
    }

    @Override
    public void addKeyboardListener(KeyboardListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.main;
    }

    protected void refreshSet() {
        this.main.setVisible(false);
        this.currentSet = this.setLoader.readLayout(this.currentSetName);
        if (this.currentSet != null) {
            for (int i = 0; i < this.letters.length; ++i) {
                ClickButton[] row = this.letters[i];
                for (int j = 0; j < row.length; ++j) {
                    ClickButton cb = row[j];
                    Character ch = this.currentSet.get(i, j);
                    if (ch != null) {
                        if (this.currentCase == KeyboardCase.Lower) {
                            cb.setText("" + Character.toLowerCase(ch.charValue()));
                        } else {
                            cb.setText("" + Character.toUpperCase(ch.charValue()));
                        }
                    } else {
                        cb.setText(null);
                    }
                    cb.setEnabled(true);
                }
            }
        } else {
            for (int i = 0; i < this.letters.length; ++i) {
                ClickButton[] row = this.letters[i];
                for (int j = 0; j < row.length; ++j) {
                    ClickButton cb = row[j];
                    cb.setText(null);
                    cb.setEnabled(false);
                }
            }
        }
        this.main.setVisible(true);
    }

    private void setAccessible() {
        this.main.setVisible(false);
        this.caps.setEnabled(this.keyboard.isAllowChangeCase() && this.keyboard.getType() != KeyboardType.Digital);
        this.space.setEnabled(this.keyboard.getType() != KeyboardType.Digital);
        if (this.keyMapping != null && this.keyboard.getLayoutNames() != null && this.keyboard.getLayoutNames().size() > 1) {
            this.set1.setEnabled(this.keyboard.getLayoutNames().contains(this.keyMapping.get("set1")));
            this.set2.setEnabled(this.keyboard.getLayoutNames().contains(this.keyMapping.get("set2")));
            this.set3.setEnabled(this.keyboard.getLayoutNames().contains(this.keyMapping.get("set3")));
        } else {
            this.set1.setEnabled(false);
            this.set2.setEnabled(false);
            this.set3.setEnabled(false);
        }
        this.main.setVisible(true);
    }

    private void initButton(ClickButton cb, KeySettings ks) {
        if (ks != null) {
            cb.setText(ks.getTitle());
        } else {
            cb.setText(null);
        }
    }

    private class LocalActionListener
    implements ActionListener {
        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block5: {
                block7: {
                    block6: {
                        block4: {
                            if (e.getSource() != BaseLetterKeyboard.this.space) break block4;
                            for (KeyboardListener kl : BaseLetterKeyboard.this.listeners) {
                                kl.onKeyPress(' ');
                            }
                            break block5;
                        }
                        if (e.getSource() != BaseLetterKeyboard.this.backspace) break block6;
                        for (KeyboardListener kl : BaseLetterKeyboard.this.listeners) {
                            kl.onClearLast();
                        }
                        break block5;
                    }
                    if (e.getSource() != BaseLetterKeyboard.this.enter) break block7;
                    for (KeyboardListener kl : BaseLetterKeyboard.this.listeners) {
                        kl.onEnter();
                    }
                    break block5;
                }
                ClickButton cb = (ClickButton)e.getSource();
                if (cb.getText() == null || cb.getText().isEmpty()) break block5;
                char ch = cb.getText().charAt(0);
                for (KeyboardListener kl : BaseLetterKeyboard.this.listeners) {
                    kl.onKeyPress(ch);
                }
            }
        }
    }

    private class Set3ActionListener
    implements ActionListener {
        private Set3ActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseLetterKeyboard.this.currentSetName = (String)BaseLetterKeyboard.this.keyMapping.get("set3");
            BaseLetterKeyboard.this.refreshSet();
        }
    }

    private class Set2ActionListener
    implements ActionListener {
        private Set2ActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseLetterKeyboard.this.currentSetName = (String)BaseLetterKeyboard.this.keyMapping.get("set2");
            BaseLetterKeyboard.this.refreshSet();
        }
    }

    private class Set1ActionListener
    implements ActionListener {
        private Set1ActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseLetterKeyboard.this.currentSetName = (String)BaseLetterKeyboard.this.keyMapping.get("set1");
            BaseLetterKeyboard.this.refreshSet();
        }
    }

    private class CapsActionListener
    implements ActionListener {
        private CapsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BaseLetterKeyboard.this.currentCase == KeyboardCase.Lower) {
                BaseLetterKeyboard.this.currentCase = KeyboardCase.Upper;
            } else {
                BaseLetterKeyboard.this.currentCase = KeyboardCase.Lower;
            }
            BaseLetterKeyboard.this.refreshSet();
        }
    }
}

