/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.keyboard.digital;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui2.keyboard.GuiKeyboard;
import ru.softlogic.gui2.keyboard.KeyboardListener;
import ru.softlogic.gui2.keyboard.digital.DigitalKeyFactory;
import ru.softlogic.input.model.field.text.Keyboard;

public class SimpleDigitalKeyboard
implements GuiKeyboard {
    private JPanel panel;
    private Set<KeyboardListener> listeners;
    private JButton[] buttons;
    private JButton cButton;
    private JButton xButton;

    public SimpleDigitalKeyboard(DigitalKeyFactory factory, JButton xButton, JButton cButton) {
        this(-1.0, -1.0, factory, xButton, cButton);
    }

    public SimpleDigitalKeyboard(double hGap, double vGap, DigitalKeyFactory factory, JButton xButton, JButton cButton) {
        if (factory == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DigitalKeyFactory");
        }
        this.xButton = xButton;
        this.cButton = cButton;
        this.listeners = new HashSet<KeyboardListener>();
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout((LayoutManager)new TableLayout(new double[]{0.3333333333333333, hGap, 0.3333333333333333, hGap, 0.3333333333333333}, new double[]{0.25, vGap, 0.25, vGap, 0.25, vGap, 0.25}));
        LocalActionListener lal = new LocalActionListener();
        this.buttons = new JButton[10];
        for (int i = 0; i < 10; ++i) {
            this.buttons[i] = factory.create(i);
            this.buttons[i].addActionListener(lal);
        }
        if (xButton != null) {
            xButton.addActionListener(lal);
        }
        if (cButton != null) {
            cButton.addActionListener(lal);
        }
        this.panel.add((Component)this.buttons[1], "0,0");
        this.panel.add((Component)this.buttons[2], "2,0");
        this.panel.add((Component)this.buttons[3], "4,0");
        this.panel.add((Component)this.buttons[4], "0,2");
        this.panel.add((Component)this.buttons[5], "2,2");
        this.panel.add((Component)this.buttons[6], "4,2");
        this.panel.add((Component)this.buttons[7], "0,4");
        this.panel.add((Component)this.buttons[8], "2,4");
        this.panel.add((Component)this.buttons[9], "4,4");
        this.panel.add((Component)this.buttons[0], "0,6,4,6,c,t");
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public void init(Keyboard keyboard) {
    }

    @Override
    public void addKeyboardListener(KeyboardListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private class LocalActionListener
    implements ActionListener {
        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (e.getSource() == SimpleDigitalKeyboard.this.xButton) {
                        for (KeyboardListener listener : SimpleDigitalKeyboard.this.listeners) {
                            listener.onClear();
                        }
                    } else if (e.getSource() == SimpleDigitalKeyboard.this.cButton) {
                        for (KeyboardListener listener : SimpleDigitalKeyboard.this.listeners) {
                            listener.onClearLast();
                        }
                    } else {
                        for (KeyboardListener listener : SimpleDigitalKeyboard.this.listeners) {
                            listener.onKeyPress(((ClickButton)e.getSource()).getSymbol().charAt(0));
                        }
                    }
                }
            });
        }
    }
}

