/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.keyboard.digital;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui2.keyboard.GuiKeyboard;
import ru.softlogic.gui2.keyboard.KeyboardListener;
import ru.softlogic.gui2.keyboard.digital.DigitalKeyFactory;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;

public class ImageDigitalKeyboard
implements GuiKeyboard {
    public static final String EXTRA_BUTTON_IMAGE_KEY = "extra-button-image";
    public static final String EXTRA_BUTTON_IMAGE_PRESS_KEY = "extra-button-press-image";
    private JPanel main = new JPanel();
    private List<ClickButton> digits;
    private ClickButton c;
    private ClickButton x;
    private ClickButton extraX;
    private Set<KeyboardListener> listeners;
    private boolean lastEnable;
    private String xTitle;
    private Keyboard keyboard;

    public ImageDigitalKeyboard(DigitalKeyFactory factory) {
        this.main.setLayout((LayoutManager)new TableLayout(new double[]{0.3333333333333333, 0.0, 0.3333333333333333, 0.0, 0.3333333333333333}, new double[]{0.25, 0.0, 0.25, 0.0, 0.25, 0.0, 0.25}));
        LocalActionListener al = new LocalActionListener();
        this.digits = new LinkedList<ClickButton>();
        for (int i = 0; i < 9; ++i) {
            ClickButton cb = factory.create(i + 1);
            cb.addActionListener(al);
            this.digits.add(cb);
            this.main.add((Component)cb, "" + i % 3 * 2 + "," + i / 3 * 2);
        }
        this.x = factory.createX();
        this.x.addActionListener(al);
        this.xTitle = this.x.getSymbol();
        this.main.add((Component)this.x, "0,6");
        this.extraX = factory.createX();
        this.extraX.setIcon((Icon)this.extraX.getClientProperty(EXTRA_BUTTON_IMAGE_KEY));
        this.extraX.setPressedIcon((Icon)this.extraX.getClientProperty(EXTRA_BUTTON_IMAGE_PRESS_KEY));
        this.extraX.addActionListener(al);
        this.main.add((Component)this.extraX, "0,6");
        ClickButton cb = factory.create(0);
        cb.addActionListener(al);
        this.digits.add(cb);
        this.main.add((Component)cb, "2,6");
        this.c = factory.createC();
        this.c.addActionListener(al);
        this.main.add((Component)this.c, "4,6");
        this.listeners = new LinkedHashSet<KeyboardListener>();
        this.lastEnable = true;
        this.init(new Keyboard(KeyboardType.Digital));
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public final void init(Keyboard keyboard) {
        boolean enable;
        this.keyboard = keyboard;
        boolean bl = enable = keyboard.getType() != KeyboardType.Letter;
        if (this.lastEnable != enable) {
            for (ClickButton cb : this.digits) {
                cb.setEnabled(enable);
            }
            this.lastEnable = enable;
        }
        this.x.setVisible(true);
        this.extraX.setVisible(false);
        if (keyboard.getExtraCharacter() != null) {
            if (this.extraX.getIcon() != null) {
                this.x.setVisible(false);
                this.extraX.setVisible(true);
            } else {
                this.x.setText("" + keyboard.getExtraCharacter());
            }
        } else {
            this.x.setText(this.xTitle);
        }
    }

    @Override
    public void addKeyboardListener(KeyboardListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.main;
    }

    private class LocalActionListener
    implements ActionListener {
        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ImageDigitalKeyboard.this.c) {
                for (KeyboardListener kl : ImageDigitalKeyboard.this.listeners) {
                    kl.onClearLast();
                }
            } else if (e.getSource() == ImageDigitalKeyboard.this.x || e.getSource() == ImageDigitalKeyboard.this.extraX) {
                if (ImageDigitalKeyboard.this.keyboard.getExtraCharacter() != null) {
                    for (KeyboardListener kl : ImageDigitalKeyboard.this.listeners) {
                        kl.onKeyPress(ImageDigitalKeyboard.this.keyboard.getExtraCharacter().charValue());
                    }
                } else {
                    for (KeyboardListener kl : ImageDigitalKeyboard.this.listeners) {
                        kl.onClear();
                    }
                }
            } else {
                ClickButton b = (ClickButton)e.getSource();
                for (KeyboardListener kl : ImageDigitalKeyboard.this.listeners) {
                    kl.onKeyPress(b.getSymbol().charAt(0));
                }
            }
        }
    }
}

