/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.keyboard.digital;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JPanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui2.keyboard.GuiKeyboard;
import ru.softlogic.gui2.keyboard.KeyboardListener;
import ru.softlogic.gui2.keyboard.digital.DigitalKeyFactory;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;

public class DigitalKeyboard
implements GuiKeyboard {
    private JPanel main = new JPanel();
    private List<ClickButton> digits;
    private ClickButton c;
    private ClickButton x;
    private Set<KeyboardListener> listeners;
    private boolean lastEnable;
    private String xTitle;
    private Keyboard keyboard;

    public DigitalKeyboard(DigitalKeyFactory factory) {
        this(factory, false);
    }

    public DigitalKeyboard(DigitalKeyFactory factory, boolean reversClearButtons) {
        this.main.setLayout((LayoutManager)new TableLayout(new double[]{0.3333333333333333, 0.0, 0.3333333333333333, 0.0, 0.3333333333333333}, new double[]{0.25, 0.0, 0.25, 0.0, 0.25, 0.0, 0.25}));
        LocalActionListener al = new LocalActionListener();
        this.digits = new LinkedList<ClickButton>();
        for (int i = 0; i < 9; ++i) {
            ClickButton cb = factory.create(i + 1);
            cb.addActionListener(al);
            this.digits.add(cb);
            this.main.add((Component)cb, "" + i % 3 * 2 + "," + i / 3 * 2);
        }
        this.x = factory.createX();
        this.x.addActionListener(al);
        this.xTitle = this.x.getSymbol();
        if (reversClearButtons) {
            this.main.add((Component)this.x, "4,6");
        } else {
            this.main.add((Component)this.x, "0,6");
        }
        ClickButton cb = factory.create(0);
        cb.addActionListener(al);
        this.digits.add(cb);
        this.main.add((Component)cb, "2,6");
        this.c = factory.createC();
        this.c.addActionListener(al);
        if (reversClearButtons) {
            this.main.add((Component)this.c, "0,6");
        } else {
            this.main.add((Component)this.c, "4,6");
        }
        this.listeners = new LinkedHashSet<KeyboardListener>();
        this.lastEnable = true;
        this.init(new Keyboard(KeyboardType.Digital));
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public final void init(Keyboard keyboard) {
        boolean enable;
        this.keyboard = keyboard;
        boolean bl = enable = keyboard.getType() != KeyboardType.Letter;
        if (this.lastEnable != enable) {
            for (ClickButton cb : this.digits) {
                cb.setEnabled(enable);
            }
            this.lastEnable = enable;
        }
        if (keyboard.getExtraCharacter() != null) {
            this.x.setText("" + keyboard.getExtraCharacter());
        } else {
            this.x.setText(this.xTitle);
        }
    }

    @Override
    public void addKeyboardListener(KeyboardListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.main;
    }

    private class LocalActionListener
    implements ActionListener {
        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DigitalKeyboard.this.c) {
                for (KeyboardListener kl : DigitalKeyboard.this.listeners) {
                    kl.onClearLast();
                }
            } else if (e.getSource() == DigitalKeyboard.this.x) {
                if (DigitalKeyboard.this.keyboard.getExtraCharacter() != null) {
                    for (KeyboardListener kl : DigitalKeyboard.this.listeners) {
                        kl.onKeyPress(DigitalKeyboard.this.keyboard.getExtraCharacter().charValue());
                    }
                } else {
                    for (KeyboardListener kl : DigitalKeyboard.this.listeners) {
                        kl.onClear();
                    }
                }
            } else {
                ClickButton b = (ClickButton)e.getSource();
                for (KeyboardListener kl : DigitalKeyboard.this.listeners) {
                    kl.onKeyPress(b.getSymbol().charAt(0));
                }
            }
        }
    }
}

